/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[履歴]ビューのテーブル定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryTableDefine {

    /** 実行状態 */
    public static final int STATUS = 0;
    /** 終了状態 */
    public static final int END_STATUS = 1;
    /** 終了値 */
    public static final int END_VALUE = 2;
    /** セッションID */
    public static final int SESSION_ID = 3;
    /** ジョブID */
    public static final int JOB_ID = 4;
    /** ジョブ名 */
    public static final int JOB_NAME = 5;
    /** 所属ジョブユニットのジョブID */
    public static final int JOBUNIT_ID = 6;
    /** 種別 */
    public static final int JOB_TYPE = 7;
    /** ファシリティID */
    public static final int FACILITY_ID = 8;
    /** スコープ */
    public static final int SCOPE = 9;
    /** 開始予定日時 */
    public static final int SCHEDULED_START_TIME = 10;
    /** 開始・再実行日時 */
    public static final int START_RERUN_TIME = 11;
    /** 終了・中断日時 */
    public static final int END_SUSPEND_TIME = 12;
    /** 実行契機種別 */
    public static final int TRIGGER_TYPE = 13;
    /** 実行契機情報 */
    public static final int TRIGGER_INFO = 14;
    /** マネージャ */
    public static final int MANAGER = 15;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = SESSION_ID;
    /** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
    public static final int SORT_ORDER = -1;

    /**
     * ジョブ[履歴]ビューのテーブル定義を取得する
     *
     * @return テーブル定義情報
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale, boolean isManagerIpRequired) {
        /** テーブル定義配列*/
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale),
                TableColumnInfoJs.STATE, 60, SWT.LEFT,
                JobMappingUtil.getHistoryName(STATUS)));
        tableDefine.add(END_STATUS, new TableColumnInfoJs(
                WebMessages.getString("end.status", locale),
                TableColumnInfoJs.END_STATUS, 60, SWT.LEFT,
                JobMappingUtil.getHistoryName(END_STATUS)));
        tableDefine.add(END_VALUE, new TableColumnInfoJs(
                WebMessages.getString("end.value", locale),
                TableColumnInfoJs.NONE, 50, SWT.LEFT,
                JobMappingUtil.getHistoryName(END_VALUE)));
        tableDefine.add(SESSION_ID, new TableColumnInfoJs(
                WebMessages.getString("session.id", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getHistoryName(SESSION_ID)));
        tableDefine.add(JOB_ID, new TableColumnInfoJs(
                WebMessages.getString("job.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getHistoryName(JOB_ID)));
        tableDefine.add(JOB_NAME, new TableColumnInfoJs(
                WebMessages.getString("job.name", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getHistoryName(JOB_NAME)));
        tableDefine.add(JOBUNIT_ID, new TableColumnInfoJs(
                WebMessages.getString("jobunit.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getHistoryName(JOBUNIT_ID)));
        tableDefine.add(JOB_TYPE, new TableColumnInfoJs(
                WebMessages.getString("type", locale),
                TableColumnInfoJs.JOB, 110, SWT.LEFT,
                JobMappingUtil.getHistoryName(JOB_TYPE)));
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getHistoryName(FACILITY_ID)));
        tableDefine.add(SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale),
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                JobMappingUtil.getHistoryName(SCOPE)));
        tableDefine.add(SCHEDULED_START_TIME, new TableColumnInfoJs(
                WebMessages.getString("scheduled.start.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getHistoryName(SCHEDULED_START_TIME)));
        tableDefine.add(START_RERUN_TIME, new TableColumnInfoJs(
                WebMessages.getString("start.rerun.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getHistoryName(START_RERUN_TIME)));
        tableDefine.add(END_SUSPEND_TIME, new TableColumnInfoJs(
                WebMessages.getString("end.suspend.time", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getHistoryName(END_SUSPEND_TIME)));
        tableDefine.add(TRIGGER_TYPE, new TableColumnInfoJs(
                WebMessages.getString("trigger.type", locale),
                TableColumnInfoJs.NONE, 90, SWT.LEFT,
                JobMappingUtil.getHistoryName(TRIGGER_TYPE)));
        tableDefine.add(TRIGGER_INFO, new TableColumnInfoJs(
                WebMessages.getString("trigger.info", locale),
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getHistoryName(TRIGGER_INFO)));
        if (isManagerIpRequired) {
            tableDefine.add(MANAGER, new TableColumnInfoJs(
                    WebMessages.getString("manager", locale),
                    TableColumnInfoJs.NONE, 150, SWT.LEFT,
                    JobMappingUtil.getHistoryName(MANAGER)));
        }

        return tableDefine;
    }
}