/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ファイル転送]ビューのテーブル定義を取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetForwardFileTableDefine {

    /** 実行状態 */
    public static final int STATUS = 0;
    /** 終了状態 */
    public static final int END_STATUS = 1;
    /** ファイル */
    public static final int FILE_NAME = 2;
    /** 転送ファシリティID */
    public static final int SRC_FACILITY_ID = 3;
    /** 転送ファシリティ名 */
    public static final int SRC_FACILITY_NAME = 4;
    /** 受信ファシリティID */
    public static final int DEST_FACILITY_ID = 5;
    /** 受信ファシリティ名 */
    public static final int DEST_FACILITY_NAME = 6;
    /** 開始・再実行日時 */
    public static final int START_RERUN_TIME = 7;
    /** 終了・中断日時 */
    public static final int END_SUSPEND_TIME = 8;
    
    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = STATUS;
    /** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
    public static final int SORT_ORDER = 1;

    /**
     * ジョブ[ファイル転送]ビューのテーブル定義を取得します。
     * 
     * @return テーブル定義情報
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** テーブル定義配列*/
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale),
                TableColumnInfoJs.STATE, 60, SWT.LEFT,
                JobMappingUtil.getFileTranferName(STATUS)));
        tableDefine.add(END_STATUS, new TableColumnInfoJs(
                WebMessages.getString("end.status", locale),
                TableColumnInfoJs.END_STATUS, 60, SWT.LEFT,
                JobMappingUtil.getFileTranferName(END_STATUS)));
        tableDefine.add(FILE_NAME, new TableColumnInfoJs(
                WebMessages.getString("file", locale),
                TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getFileTranferName(FILE_NAME)));
        tableDefine.add(SRC_FACILITY_ID,new TableColumnInfoJs(
                WebMessages.getString("forward.source", locale) +
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getFileTranferName(SRC_FACILITY_ID)));
        tableDefine.add(SRC_FACILITY_NAME, new TableColumnInfoJs(
                WebMessages.getString("forward.source", locale) +
                WebMessages.getString("facility.name", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getFileTranferName(SRC_FACILITY_NAME)));
        tableDefine.add(DEST_FACILITY_ID, new TableColumnInfoJs( 
                WebMessages.getString("forward.destination",locale) +
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getFileTranferName(DEST_FACILITY_ID)));
        tableDefine.add(DEST_FACILITY_NAME, new TableColumnInfoJs( 
                WebMessages.getString("forward.destination",locale) +
                WebMessages.getString("facility.name", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getFileTranferName(DEST_FACILITY_NAME)));
        tableDefine.add(START_RERUN_TIME, new TableColumnInfoJs(
                WebMessages.getString("start.rerun.time",locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getFileTranferName(START_RERUN_TIME)));
        tableDefine.add(END_SUSPEND_TIME, new TableColumnInfoJs(
                WebMessages.getString("end.suspend.time", locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getFileTranferName(END_SUSPEND_TIME)));

        return tableDefine;
    }
}