/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General License for more details.

*/

package com.necsoft.hinemos.webclient.jobmanagement;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ管理機能用の定数を定義するクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public interface JobManagementConstants {

    static final int ROW_NUM = 1000;

    // ジョブ「一覧」ビュー用の定数
    // ジョブツリー一覧用の定数
    static final String CSS_TREE_JOB_COMPOSITE = "dynatree-ico-job-composite";

    static final String CSS_TREE_JOBUNIT = "dynatree-ico-jobunit";

    static final String CSS_FORBIDEDEN_TREE_JOBUNIT = "dynatree-ico-forbidden_jobunit";

    static final String CSS_TREE_JOBNET = "dynatree-ico-jobnet";

    static final String CSS_TREE_JOB = "dynatree-ico-job";

    static final String CSS_TREE_FILEJOB = "dynatree-ico-filejob";

    // ジョブ一覧用の定数
    static final int JOB_LIST_HEADER_NUM = 10;

    /** ジョブ「スケジュール」ビュー用の定数(マネージャ列なし) */
    static final int SCHEDULE_HEADER_NUM_WITHOUT_MANAGER = 12;

    /** ジョブ「スケジュール」ビュー用の定数(マネージャ列あり) */
    static final int SCHEDULE_HEADER_NUM_WITH_MANAGER = 13;

    /** ジョブ「履歴」ビュー用の定数(マネージャ列なし) */
    static final int HISTORY_HEADER_NUM_WITHOUT_MANAGER = 15;

    /** ジョブ「履歴」ビュー用の定数(マネージャ列あり) */
    static final int HISTORY_HEADER_NUM_WITH_MANAGER = 16;

    // ジョブ「詳細」ビュー用の定数
    static final int JOB_DETAIL_HEADER_NUM = 13;

    // ジョブ「ノード詳細」ビュー用の定数
    static final int NODE_HEADER_NUM = 7;

    // ジョブ「ファイル転送」ビュー用の定数
    static final int FORWARD_FILE_HEADER_NUM = 9;

    /** ジョブ（文字列） */
    static final String STRING_JOB = WebMessages.getString("job");

    /** コーテーション */
    static final String SINGLE_QUOTE = "\'";

    /** HTMLコーテーション */
    static final String SINGLE_QUOTE_HTML = "&#39;";
}
