/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.composite;

import java.util.ArrayList;
import java.util.Date;
import java.util.Comparator;

/**
 * CommonTableViewerSorterクラス用のComparatorクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class CommonTableViewerSorter implements Comparator<Object> {
    /** カラムインデックス */
    protected int m_columnIndex = 0;

    /** カラムインデックス */
    protected int m_columnIndex2 = 0;

    /** ソートオーダー */
    protected int m_order = 1;

    /**
     * コンストラクタ
     *
     * @param column
     *            ソート対象カラムインデックス
     * @since 1.0.0
     */
    public CommonTableViewerSorter(int columnIndex) {
        this(columnIndex, -1, 1);
    }

    /**
     * コンストラクタ
     *
     * @param column
     *            ソート対象カラムインデックス
     * @param columnIndex
     */
    public CommonTableViewerSorter(int columnIndex, int columIndex2) {
        this(columnIndex, columIndex2, 1);
    }

    /**
     * コンストラクタ
     *
     * @param column
     *            ソート対象カラムインデックス
     * @param order
     *            ソートオーダー
     * @since 1.0.0
     */
    public CommonTableViewerSorter(int columnIndex, int columnIndex2, int order) {
        super();

        this.m_columnIndex = columnIndex;
        // セカンドソーターを必要としない場合には-1が入ってる。
        this.m_columnIndex2 = columnIndex2;

        // 昇順・降順の設定　1: 昇順　-1:降順
        this.m_order = order;
    }

    /**
     * 比較処理
     *
     * @param viewer
     * @param e1
     * @param e2
     * @return 比較結果。superクラスの結果をソートオーダーにより反転する
     * @since 1.0.0
     */
    @Override
    public int compare(Object e1, Object e2) {
        if (e1 == null || e2 == null) {
            return 0;
        }
        if (e1 instanceof ArrayList && e2 instanceof ArrayList) {
            Object object1 = ((ArrayList<?>) e1).get(m_columnIndex);
            Object object2 = ((ArrayList<?>) e2).get(m_columnIndex);

            /*
             * if (object1 == null || object2 == null) { return 0; }
             */

            int rtn = 0;
            if ((object1 == null) && (object2 == null)) {
                return 0;
            } else if ((object1 == null) && (object2 != null)) {
                rtn = -1;
            } else if ((object1 != null) && (object2 == null)) {
                rtn = 1;
            } else {
                if (object1.getClass() == Date.class
                        && object2.getClass() == Date.class) {
                    rtn = ((Date) object1).compareTo((Date) object2);

                } else if (object1.getClass() == Integer.class
                        && object2.getClass() == Integer.class) {
                    // Intergerの場合には、compareではなく値の大小を比較する。
                    // 2と10だと2を前にする。
                    rtn = ((Integer) object1).intValue()
                            - ((Integer) object2).intValue();
//                } else if (object1.toString().matches(FacilityConstant.IP_ADDRESS_PARTERN)) {
//                    String ip1 = object1.toString();
//                    String ip2 = object2.toString();
//                    // IPアドレスの大小を比較する
//                    String[] ip1Numbers = ip1.split("\\.");
//                    String[] ip2Numbers = ip2.split("\\.");
//                    for (int i = 0; i < ip1Numbers.length; i++) {
//                        int ip1Num = Integer.parseInt(ip1Numbers[i]);
//                        int ip2Num = Integer.parseInt(ip2Numbers[i]);
//                        rtn = ip1Num - ip2Num;
//                        if (rtn != 0) {
//                            break;
//                        }
//                    }
                } else {
                    rtn = (object1.toString()).compareTo(object2.toString());
                }
            }

            // 第1ソートが等価で第２ソートが有効な場合には
            // 第2ソートを行う。
            if (rtn == 0 && m_columnIndex2 >= 0) {

                object1 = ((ArrayList<?>) e1).get(m_columnIndex2);
                object2 = ((ArrayList<?>) e2).get(m_columnIndex2);

                if ((object1 == null) && (object2 == null)) {
                    return 0;
                } else if ((object1 == null) && (object2 != null)) {
                    rtn = -1;
                } else if ((object1 != null) && (object2 == null)) {
                    rtn = 1;
                } else {
                    // 上と同じ
                    if (object1.getClass() == Date.class
                            && object2.getClass() == Date.class) {
                        rtn = ((Date) object1).compareTo((Date) object2);

                    } else if (object1.getClass() == Integer.class
                                && object2.getClass() == Integer.class) {
                            // Intergerの場合には、compareではなく値の大小を比較する。
                            // 2と10だと2を前にする。
                            rtn = ((Integer) object1).intValue()
                                    - ((Integer) object2).intValue();
                    } else {
                        rtn = (object1.toString())
                                .compareTo(object2.toString());
                    }
                }

            }
            if (m_order == 1) {
                return rtn;
            } else {
                return 0 - rtn;
            }
        }

        return 0;
    }

    /**
     * ソート対象カラムインデックス取得
     *
     * @return カラムインデックス
     * @since 1.0.0
     */
    public int getColumnIndex() {
        return this.m_columnIndex;
    }
}