/*

Copyright (C) NEC Corporation 2012-2013. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.common;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.repository.bean.NodeConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.bean.PropertyValue;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.form.GridForm;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.json.TreeGridJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * HTMLに関する処理を定義する共有クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class DataProcess {

    private static final Map<String, Object> getRowFromProperty(Property property) {
        return getRowFromProperty(property, JsConstant.TREEGRID_ROOT_LEVEL);
    }

    private static final Map<String, Object> getRowFromProperty(
            Property property, int level) {
        return getRowFromProperty(property, level, false);
    }

    private static final Map<String, Object> getRowFromProperty(
            Property property, int level, boolean valueWithChild) {
        Map<String, Object> data = new HashMap<String, Object>();
        Property proParent;

        // Declare component of data (Default value is ROOT)
        String id;
        String name;
        String value = HtmlEncode.SPACE;
        String parent = JsConstant.TREEGRID_ROOT_PARENT;
        boolean isLeaf = false;
        boolean expanded = false;

        // Get id, name
        id = property.getID();
        name = property.getName();

        // Get value
        String propValue = "";
        if (property.getValue() != null) {
            propValue = property.getValue().toString();
        }

        if ((property.getChildren() == null)
                || ((property.getChildren().length < 1) || (valueWithChild))) {
            // This is a leaf which doesn't have any child
            if (property.getChildren().length < 1) {
                isLeaf = true;
            }

            StringBuffer buf = new StringBuffer();

            // Set value properly
            if ((property.getSelectValues() != null)
                    && (property.getSelectValues().length > 0)) {
                // This is a select box
                Object[][] selectContent = property.getSelectValues();

                // Append select
                buf.append("<select class='");
                buf.append(CssClass.GRID_INPUT_SELECT);
                buf.append("' id='");
                buf.append(id);
                buf.append("'>");

                // Append options
                if (selectContent.length > 1) {
                    Object[] selValues = selectContent[0];
                    Object[] selDisplays = selectContent[1];
                    int selLen = selValues.length;
                    if (selDisplays.length == selLen) {
                        for (int cnt = 0; cnt < selLen; cnt++) {
                            String display = "";
                            if (selDisplays[cnt] instanceof HashMap) {
                                HashMap map = (HashMap) selDisplays[cnt];

                                //子Propertyを取得
                                display = map.get(PropertyConstant.MAP_VALUE)
                                                                    .toString();
                            } else {
                                display = selDisplays[cnt].toString();
                            }
                            buf.append("<option value='");
                            buf.append(selValues[cnt].toString());
                            buf.append("'");

                            // Check selected
                            if (selValues[cnt].toString().equals(propValue)) {
                                buf.append(" selected='selected'");
                            }

                            buf.append(">");
                            buf.append(display);
                            buf.append("</option>");
                        }
                    }
                }

                buf.append("</select>");
            } else {
                // This is a input text
                buf.append("<input type='text' id='");
                buf.append(id);
                buf.append("' class='");

                String editor = property.getEditor();

                // Check type value of input text
                if (editor.equals(PropertyClass.DATETIME_EDITOR)) {
                    // This is a datetime input
                    buf.append(CssClass.GRID_INPUT_DATETIME);
                    buf.append("' readonly='readonly");
                } else if (editor.equals(PropertyClass.JOBID_EDITOR)) {
                    buf.append(CssClass.GRID_INPUT_JOBID);
                    buf.append("' readonly='readonly");
                } else {
                    buf.append(CssClass.GRID_INPUT_NORMAL);
                    // Check for edit permission
                    if (property.getModify() == PropertyConstant.MODIFY_NG) {
                        buf.append("' readonly='readonly");
                    }
                    buf.append("' value='");

                    if (editor.equals(PropertyConstant.EDITOR_NUM)) {
                        buf.append("' min='");
                        buf.append(property.getLowerBound());
                        buf.append("' max='");
                        buf.append(property.getUpperBound());
                    }

                    buf.append(propValue);
                }

                buf.append("'/>");

                if (editor.equals(PropertyClass.JOBID_EDITOR)) {
                    buf.append("<button class='");
                    buf.append(CssClass.GRID_INNER_BUTTON_OPEN_TREE_JOB);
                    buf.append("'/><input type='hidden' id='jobManager'/>");
                }
            }

            value = buf.toString();
        }

        // Get parent property
        proParent = (Property) property.getParent();
        if (proParent.getID() != null) {
            parent = proParent.getID();
        }

        // Create array
        data.put("id", id);
        data.put("name", name);
        data.put("value", value);
        data.put("level", level);
        data.put("parent", parent);
        data.put("isLeaf", isLeaf);
        data.put("expanded", expanded);

        return data;
    }

    /**
     * This method used for convert header of grid to JSON data.
     *
     * @author hungcv
     * @version 2.0
     * @since 2012/07/11
     * @param tblDefine
     *            : ArrayList<TableColumnInfoJs>
     * @param locale
     *            : java.util.Locale
     * @param row_num
     *            : int
     * @param column_index
     *            : int
     * @param sort_order
     *            : int
     * @return GridHeaderJson
     */
    public static final GridHeaderJson doConvertTableDefineToJson(
            ArrayList<TableColumnInfoJs> tblDefine, boolean recordsFlag, Locale locale,
            int row_num, int column_index, int sort_order) {
        // Create JSON
        return doConvertTableDefineToJson(tblDefine, recordsFlag, locale, row_num
                ,column_index, sort_order, false);
    }

    public static final GridHeaderJson doConvertTableDefineToJson(
            ArrayList<TableColumnInfoJs> tblDefine, boolean recordsFlag, Locale locale,
            int row_num, int column_index, int sort_order, boolean indexlikeName) {
        // Create JSON
        GridHeaderJson result = new GridHeaderJson();
        result.setColNames(ConvertListUtil.columnInfoToColNames(tblDefine));
        result.setColModel(ConvertListUtil.columnInfoToColModel(tblDefine, indexlikeName));

        result.setRowNum(row_num);
        result.setSortname(column_index);
        if (indexlikeName) {
            result.setSortname(tblDefine.get(column_index).getModelName());
        }

        result.setSortorder(SortOrderUtil.getJsString(sort_order));
        if (recordsFlag) {
            result.setRecordtext(WebMessages.getString("records",
                    new Object[] { "{1}" }, locale));
            result.setEmptyrecords(WebMessages.getString("records",
                    new Object[] { "0" }, locale));
            result.setExceedrecord(WebMessages.getString("exceed.records",
                    new Object[] { "{1}" }, locale));
        }
        return result;
    }

    /**
     * This method used for convert data of grid to JSON data.
     *
     * @author hungcv
     * @version 1.0
     * @since 2012/07/11
     * @param listInfoData
     *            : ArrayList<ArrayList<Object>>
     * @param locale
     *            : java.util.Locale
     * @return GridDataJson
     */
    public static final GridDataJson doConvertTableContentToJson(
            List<ArrayList<Object>> listInfoData) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList<Object> infoData = listInfoData.get(countRow);
            result.addRow(infoData, String.valueOf(countRow + 1));
        }

        // Set other content
        result.setRecords(listInfoData.size());
        return result;
    }

    /**
     * This method used for convert data of grid to JSON data.
     *
     * @author hungcv
     * @version 1.0
     * @since 2012/07/11
     * @param propertyEvent
     *            : Property
     * @param language
     *            : String
     * @return GridDataJson
     */
    public static final GridDataJson doConvertEventInfoToJson(Property propertyEvent) {
        GridDataJson result = new GridDataJson();
        Object[] properties = propertyEvent.getChildren();
        int i = 0; //index
        for (Object object : properties) {
            Property property = (Property) object;
            List<Object> row = new ArrayList<Object>();

            String type;
            Map<String, Object> option = null;
            PropertyValue objValue = new PropertyValue();
            String editor = property.getEditor();
            Object value = property.getValue();

            // Check null for editor
            if (editor == null) {
                editor = PropertyConstant.EDITOR_TEXT;
            }

            if (editor.equals(PropertyConstant.EDITOR_BOOL)) {
                type = JsConstant.PROPERTY_TYPE_BOOL;
                option = new HashMap<String, Object>();
                option.put("disabled", true);
            } else if (editor.equals(PropertyConstant.EDITOR_TEXTAREA)) {
                type = JsConstant.PROPERTY_TYPE_TEXTAREA;
                value = StringEscapeUtils.escapeHtml4(value.toString());
            } else if (editor.equals(PropertyConstant.EDITOR_DATETIME)) {
                type = JsConstant.PROPERTY_TYPE_DATETIME;
                if (value != null) {
                    value = ((Date) value).getTime();
                }
            } else {
                switch (i) {
                case 0:         //Priority
                    type = JsConstant.GRID_FMATTER_PRIORITY;
                    value = Integer.parseInt(value.toString());
                    break;

                case 12:        //Confirmed
                    type = JsConstant.GRID_FMATTER_CONFIRM_TYPE;
                    value = Integer.parseInt(value.toString());
                    break;

                default:        //Others
                    type = JsConstant.PROPERTY_TYPE_TEXT;
                    value = StringEscapeUtils.escapeHtml4(value.toString());
                    break;
                }
            }
            ++i;

            // Set object
            objValue.setType(type);
            objValue.setValue(value);
            if (option != null) {
                objValue.setOption(option);
            }

            row.add(property.getName());
            row.add(objValue);
            result.addRow(row);
        }

        // Set other content
        result.setRecords(properties.length);
        return result;
    }

    /**
     * This method used for convert data row of grid to TreeGridJson data.
     *
     * @author hungcv
     * @version 1.0
     * @since 2011/12/14
     * @param tblDefine
     *            : ArrayList<?>
     * @return GridDataJson
     */
    public static final TreeGridJson doConvertFilterToJson(Property propertyInfo) {

        // Create JSON
        TreeGridJson result = new TreeGridJson();
        Object[] propertiesL0 = propertyInfo.getChildren();
        int lengtL0 = propertiesL0.length;

        // Create data
        for (int cntL0 = 0; cntL0 < lengtL0; cntL0++) {
            Property propertyL0 = (Property) propertiesL0[cntL0];
            // Set data row
            result.addData(DataProcess.getRowFromProperty(propertyL0));
            Object[] propertiesL1 = propertyL0.getChildren();
            if ((propertiesL1 != null) && (propertiesL1.length > 0)) {
                int lengtL1 = propertiesL1.length;
                for (int cntL1 = 0; cntL1 < lengtL1; cntL1++) {
                    Property propertyL1 = (Property) propertiesL1[cntL1];
                    result.addData(DataProcess
                            .getRowFromProperty(propertyL1, 1));
                }
            }
        }
        return result;
    }

    /**
     * This method used for sort data of grid.
     *
     * @author hungcv
     * @version 1.0
     * @since 2011/12/14
     * @param form
     *            : GridForm
     * @param listInfoData
     *            : ArrayList<?>
     * @param sortColumnIndex
     *            : int
     * @param sortOrder
     *            : int
     * @return void
     */
    public static List<ArrayList<Object>> doSortListDataInfo(GridForm form, List<ArrayList<Object>> listInfoData, int sortColumnIndex, int sortOrder) {
        if (form.getSidx() != null && !form.getSidx().trim().equals("")) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !form.getSord().trim().equals("")) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }
        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
        return listInfoData.subList(0, form.getMaxRowNum() > listInfoData.size() ? listInfoData.size() : form.getMaxRowNum());
    }

    public static final int getViewerSchedule(Date date, Date today) {
        // 中間変数を宣言
        SimpleDateFormat m_formatter = new SimpleDateFormat(
                                             Constants.DATE_YYYY_MM_DD);
        // Set time is 00:00:00 for compare
        date = m_formatter.parse(m_formatter.format(date),
                                                new ParsePosition(0));
        return date.compareTo(today);
    }

    public static final GridDataJson doConvertNodePropertyToJson(Object[] listInfoData) {
        // Create JSON
        GridDataJson result = new GridDataJson();
        generateSerializedData(result, listInfoData,
                JsConstant.TREEGRID_ROOT_LEVEL,
                JsConstant.TREEGRID_ROOT_PARENT, "");
        return result;
    }
    private static final void generateSerializedData(GridDataJson result, Object[] listItem,
            int level, String parentId, String sub) {

        boolean isLeaf;

        for (int count = 0; count < listItem.length; count++) {
            Property item = (Property) listItem[count];
            if (item.getChildren().length != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            // Add data
            result.addRow(doConvertPropertyToArray(item, level, parentId,
                    isLeaf, sub));

            // Generate children data
            if (!isLeaf) {
                String more_sub = RepositoryConstants.getIdOfPropertyMulti(
                        item.getID(), item.getChildren());
                generateSerializedData(result, item.getChildren(), level + 1,
                        item.getID() + more_sub, more_sub);
            }
        }
    }

    private static final ArrayList<Object> doConvertPropertyToArray(Property prop,
            int level, String parentId, boolean isLeaf, String sub) {

        // Create JSON
        ArrayList<Object> result = new ArrayList<Object>();
        String id = prop.getID();
        String id_sub = id + sub;
        PropertyValue objValue = new PropertyValue();
        String editor;
        Object value;
        String type;
        Map<String, Object> option = null;

        // Get value of expanded
        boolean expanded = false;

        //expand for "Basic Information", "Service" and "Device"
        if(id == NodeConstant.BASIC_INFORMATION || id == NodeConstant.SERVICE || id == NodeConstant.DEVICE)
        {
            expanded = true;
        }
        if ((!isLeaf) && (level == JsConstant.TREEGRID_ROOT_LEVEL)) {
            if (RepositoryConstants.isMultiProperty(id)) {
                id_sub += RepositoryConstants.getIdOfPropertyMulti(id,
                        prop.getChildren());
            }
        }

        // Set object value
        editor = prop.getEditor();
        value = prop.getValue();

        // Check null for editor
        if (editor == null) {
            editor = PropertyConstant.EDITOR_TEXT;
        }

        if (editor.equals(PropertyConstant.EDITOR_BOOL)) {
            type = JsConstant.PROPERTY_TYPE_BOOL;
            option = new HashMap<String, Object>();
            option.put("disabled", true);
        } else if (editor.equals(PropertyConstant.EDITOR_TEXTAREA)) {
            type = JsConstant.PROPERTY_TYPE_TEXTAREA;
            value = StringEscapeUtils.escapeHtml4(value.toString());
        } else if (editor.equals(PropertyConstant.EDITOR_DATETIME)) {
            type = JsConstant.PROPERTY_TYPE_DATETIME;
            if (value != null) {
                value = ((Date) value).getTime();
            }
        } else {
            type = JsConstant.PROPERTY_TYPE_TEXT;
            value = StringEscapeUtils.escapeHtml4(value.toString());
        }

        // Set object
        objValue.setType(type);
        objValue.setValue(value);
        if (option != null) {
            objValue.setOption(option);
        }

        // Construct result
        result.add(id_sub);
        result.add(prop.getName());
        result.add(objValue);

        // Add properties for tree grid
        result.add(level);
        result.add(parentId);
        result.add(isLeaf);
        result.add(expanded);
        result.add(JsConstant.TREE_LOADED);

        return result;
    }

    /**
     * This method is used for convert data row of grid to TreeGridJson data.
     *
     * @author thundh
     * @since 2013/01/16
     * @param propertyInfo
     *            : Property
     * @return TreeGridJson
     */
    public static final TreeGridJson doConvertOperationInfoToJson(
        Property propertyInfo) {

        // Create JSON
        TreeGridJson result = new TreeGridJson();
        Object[] propertiesL0 = propertyInfo.getChildren();
        int lengtL0 = propertiesL0.length;

        // Create data
        for (int cntL0 = 0; cntL0 < lengtL0; cntL0++) {
            Property propertyL0 = (Property) propertiesL0[cntL0];
            // Set data row
            if (propertyL0.getID().equals(JobOperationConstant.CONTROL)) {
                result.addData(DataProcess.getRowFromProperty(
                    propertyL0, JsConstant.TREEGRID_ROOT_LEVEL, true));
            } else {
                result.addData(DataProcess.getRowFromProperty(propertyL0));
            }
            Object[] propertiesL1 = propertyL0.getChildren();
            if ((propertiesL1 != null) && (propertiesL1.length > 0)) {
                int lengtL1 = propertiesL1.length;
                for (int cntL1 = 0; cntL1 < lengtL1; cntL1++) {
                    Property propertyL1 = (Property) propertiesL1[cntL1];
                    result.addData(DataProcess
                            .getRowFromProperty(propertyL1, 1));
                }
            }
        }
        return result;
    }
}
