/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ファシリティのタイプ（スコープ、ノードなど）の定数クラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public interface FacilityConstant {
    /** コンポジット（ファシリティの種別） */
    static final int TYPE_COMPOSITE = 2;

    /** スコープ（ファシリティの種別） */
    static final int TYPE_SCOPE = 0;

    /** ノード（ファシリティの種別） */
    static final int TYPE_NODE = 1;

    /** スコープ（文字列） */
    static final String STRING_SCOPE = WebMessages.getString("scope");

    /** マネージャ（文字列） */
    static final String STRING_MANAGER = WebMessages.getString("manager");

    /** IPアドレスのパターン */
    static final String IP_ADDRESS_PARTERN = "(\\d{1,3}\\.){3}\\d{1,3}";

}