/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
//import org.eclipse.swt.widgets.Composite;

//import com.clustercontrol.composite.FacilityTreeComposite;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.FacilityTreeItemUtil;
import com.clustercontrol.ws.repository.FacilityTreeItem;

/**
 * スコープツリーアイテムを取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTree {
    // ログ
    private static Log m_log = LogFactory.getLog(FacilityTree.class);

    // ファシリティツリーのクライアント側ローカルキャッシュを保持
    private static FacilityTreeItem m_facilityTreeCache = null;
    
    /**
     * スコープツリー構造を返します。
     * 
     * @return スコープツリー構造
     */
    public FacilityTreeItem getTreeItem(EndpointManager endpointManager, String managerIp) {
        FacilityTreeItem item = null;

        // 存在しない場合はキャッシュ再交信再取得
        refleshCache(endpointManager, managerIp);
        
        // 要素を取得
        item = FacilityTreeItemUtil.deepCopy(m_facilityTreeCache, null);

        return item;
    }

    /**
     * セパレータを取得します。
     * 
     * スコープの区切り文字（セパレータ）を取得します。
     * 
     * @return セパレータ文字列
     */
    public String getSeparator() {
        String separator = ">";
        return separator;
    }

    /**
     * 保持しているローカルキャッシュをクリアして画面を再描画する
     */
    public static void clearCache() {
        // キャッシュ情報を削除する
        m_facilityTreeCache = null;
    }

    /**
     * キャッシュのリフレッシュ
     */
    private static void refleshCache(EndpointManager endpointManager, String managerIp) {
        // 再登録
        FacilityTreeItem item = null;
        try {
            item = RepositoryEndpointWrapper.getFacilityTree(endpointManager, managerIp);

            if (item != null) {
                m_facilityTreeCache = item;
            }

        } catch (Exception e) {
            m_log.warn("refleshCache(), " + e.getMessage(), e);
            return;
        }
    }
}