/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.accesscontrol.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * URLリストファイルを操作するクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class UrlListFileOperator {

    private static final Logger logger = Logger.getLogger(UrlListFileOperator.class);

    /**
     * ファイルからURLリストを取得する
     * @param urlListFilePath URLリストファイルパス
     * @return URLリスト
     */
    public static List<String> getUrlList(String urlListFilePath) {
        File file = new File(urlListFilePath);
        FileReader fr = null;
        BufferedReader br = null;
        List<String> urlList = new ArrayList<String>();
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            while (br.ready()) {
                String content = br.readLine();
                if (content != null && !content.trim().isEmpty()) {
                    urlList.add(content);
                }
            }
            return urlList;
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
            return urlList;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            } catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }
}
