/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.accesscontrol.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.accesscontrol.bean.UserBean;
import com.necsoft.hinemos.webclient.accesscontrol.util.UrlListFileOperator;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;

/**
 * 初期表示ログイン画面のサブレットを定義するクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LoginServlet extends HttpServlet implements AccessControlConstants {

    private static final long serialVersionUID = 8524643650658167194L;

    private static Logger m_log = Logger.getLogger(CommonServlet.class);

    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        // Initialize environment
        try {
            initEnvironment(request, response);
        } catch (IOException e) {
            m_log.error(e.getMessage());
        }

        // 中間変数を宣言
        String localAddr = request.getLocalAddr();
        HttpSession session = request.getSession(true);

        ServletContext application = request.getSession().getServletContext();
        @SuppressWarnings("unchecked")
        // applicationからURLリストを取得
        List<String> urlList = (List<String>)application.getAttribute(URL_LIST);
        if (urlList == null) {
            urlList = UrlListFileOperator.getUrlList((String)application.getAttribute(URL_LIST_FILE_PATH));
            application.setAttribute(URL_LIST, urlList);
        }

        // セッションからuserBeanを取得
        @SuppressWarnings("unchecked")
        List<UserBean> userBeanList = (List<UserBean>) session.getAttribute(USER_BEAN);

        if (userBeanList == null) {
            userBeanList = new ArrayList<UserBean>();
            UserBean userBean = setDefaultUserBean(localAddr);
            if (urlList.size() > 0) {
                userBean.setUrlServer(urlList.get(0));
            }
            userBeanList.add(userBean);

            // セッションにuserBeanを登録
            session.setAttribute(USER_BEAN, userBeanList);
        }

        // login.jspにフォワードする
        try {
            getServletContext().getRequestDispatcher(
                    "/jsp/accesscontrol/login.jsp").forward(request, response);
        } catch (Exception e) {
            m_log.error(e.getMessage());
        }
    }


    /**
     * Handles the HTTP <code>POST</code> method.
     *
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        doGet(request, response);
    }

    private void initEnvironment(HttpServletRequest request,
            HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public UserBean setDefaultUserBean(String localAddress) {
        // 非存在の場合、
        UserBean userBean = new UserBean();
        userBean.setUserName(HINEMOS_USER_DEFAULT);
        userBean.setUrlServer(HINEMOS_HTTP_PROTOCAL_DEFAULT
                + localAddress
                + HINEMOS_HTTP_PORT_DEFAULT);
        return userBean;
    }
}
