/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.accesscontrol.bean;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.necsoft.hinemos.webclient.bean.FacilityConstant;

/**
 * サーバアクセスに関する属性を設定するクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 **/
public class UserBean implements Serializable {

    /**
	 *
	 */
    private static final long serialVersionUID = 4826509762417671320L;

    private String userName;

    private String password;

    private String urlServer;

    private String errMessage;

    private Locale locale;

    public UserBean() {
        locale = new Locale("en");
    }

    /**
     * @return the userName
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName
     *            the userName to set
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the urlServer
     */
    public String getUrlServer() {
        return urlServer;
    }

    /**
     * @param urlServer
     *            the urlServer to set
     */
    public void setUrlServer(String urlServer) {
        this.urlServer = urlServer;
    }

    public String getManagerIp() {
        if (this.urlServer == null) {
            return "";
        }
        Pattern ipAddressPattern = Pattern.compile(FacilityConstant.IP_ADDRESS_PARTERN);
        Matcher matcher = ipAddressPattern.matcher(this.urlServer);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }
    /**
     * @return the errMessage
     */
    public String getErrMessage() {
        return errMessage;
    }

    /**
     * @param errMessage
     *            the errMessage to set
     */
    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    /**
     * @return the locale
     */
    public Locale getLocale() {
        return locale;
    }

    /**
     * @param locale
     *            the locale to set
     */
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}