/*

Copyright (C) NEC Corporation 2012. All Rights Reserved.
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved.

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

*/

package com.necsoft.hinemos.webclient.accesscontrol;

public interface AccessControlConstants {
    // Pattern for validation
    static final String USER_ID_PARTERN = "^[0-9a-zA-Z\\u002d\\u005f]*$";

    //static final String URL_SERVER_PARTERN = "^(jnp\\u003a\\u002f\\u002f)?[a-zA-Z0-9][a-zA-Z0-9\\u002d\\u002e]*(\\u003a\\d{0,5})?$";
    static final String URL_SERVER_PARTERN = "^(http\\u003a\\u002f\\u002f)?[a-zA-Z0-9][a-zA-Z0-9\\u002d\\u002e]*(\\u003a\\d{0,5})?[a-zA-Z0-9\\u002d\\u002e\\u002f]*$";
    // Default inputs
    static final String HINEMOS_USER_DEFAULT = "hinemos";

    //static final String HINEMOS_JNP_PROTOCAL_DEFAULT = "jnp://";
    static final String HINEMOS_HTTP_PROTOCAL_DEFAULT = "http://";

    //static final String HINEMOS_JNP_PORT_DEFAULT = ":1099";
    static final String HINEMOS_HTTP_PORT_DEFAULT = ":8080/HinemosWS/";

    // Views
    static final String VIEW_LOGIN_JSP = "/jsp/accesscontrol/login.jsp";

    // User
    static final String USER_BEAN = "userBean";

    //LOGIN MANAGER
    static final String LOGIN_MANAGER = "loginManager";

    //URL List
    static final String URL_LIST = "urlList";

    // User
    static final String THE_SAME_ID_AND_PWD_FLG = "useTheSameIDAndPwd";

    /** マルチログインの場合、複数のユーザID、パスワードと接続先URLの間のデリミタ */
    static final String SPLIT_FOR_MULTI_LOGIN = ",";

    /** URLリスト一覧ファイルパスパラメータ名 */
    static final String URL_LIST_FILE_PATH = "multi_login_urllist_path";
}
