<%--
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
--%>


<%@page pageEncoding="UTF-8"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setBundle basename="com.necsoft.hinemos.webclient.lang.messages" />
<%@page import="java.util.List" %>
<%@page import="com.necsoft.hinemos.webclient.accesscontrol.bean.UserBean" %>
<%@page import="com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants" %>
<%
@SuppressWarnings("unchecked")
List<UserBean> userBeanList = (List<UserBean>)session.getAttribute(AccessControlConstants.USER_BEAN);
String useTheSameIDAndPwd = (String)session.getAttribute(AccessControlConstants.THE_SAME_ID_AND_PWD_FLG);
@SuppressWarnings("unchecked")
List<String> urlList = (List<String>)application.getAttribute(AccessControlConstants.URL_LIST);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
	<title><fmt:message key="login" /></title>
	<link rel="shortcut icon" href="images/icon.ico" />

	<link rel="stylesheet" type="text/css" href="jquery/jquery-ui.css" />
	<link rel="stylesheet" type="text/css" href="jquery/layout-default.css" />	
	<link rel="stylesheet" type="text/css" href="css/login.css"/>
	
	<script type="text/javascript" src="jquery/jquery.js"></script>
	<script type="text/javascript" src="jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="jquery/jquery.layout.js"></script>
	<script type="text/javascript" src="language/accesscontrol/login.js"></script>
</head>
<body>
	<div class="ui-layout-north">
		<img src=<fmt:message key="imgLogo"/>>
	</div>
	<div class="ui-layout-center">
		<img src=<fmt:message key="imgTitle"/>>
		<center>
		<div id="frm-login" >
				<div class="lbl-header">
					<span class="hinemos-icon"></span>
					<span class="hinemos-label"><fmt:message key="login" /></span>
				</div>
				<table class="tbl-login">
					<%for (int i = 0; i < userBeanList.size(); i++) { 
						if (0 != i) { %>
							<tr><td colspan="2"><hr class="split_hr" /></td></tr>
						<%} %>
						<tr>
							<td class="lbl-input"><fmt:message key="user.id" />:</td>
							<td><input class="login-input" type="text" name="userNameInput" value="<%=userBeanList.get(i).getUserName() %>" maxlength=64 /></td>
						</tr>
						<tr>
							<td class="lbl-input"><fmt:message key="password"/>:</td>
							<td><input class="login-input" type="password" name="passwordInput" autocomplete="off" value="" maxlength=64 /></td>
						</tr>
						<tr>
							<td class="lbl-input"><fmt:message key="connection.url"/>:</td>
							<td class="url-server-td">
								<input style="width: 192px;" class="url-server-input" type="text" name="urlServerInput" value="<%=userBeanList.get(i).getUrlServer() %>" maxlength=100 />
								<select class="urlList" onchange="this.previousSibling.previousSibling.value=this.options[this.selectedIndex].value;">
									<option></option>
								<%
								if (urlList != null) {
									for (int j = 0; j < urlList.size(); ++j) {
								%>
									<option value="<%=urlList.get(j) %>"><%=urlList.get(j) %></option>
								<%
									}
								}
								%>
								</select>
							</td>
						</tr>
					<%} %>
				</table>
			<form action="login_auth" method="post">
				<input type="hidden" name="userName" id="multiUserName">
				<input type="hidden" name="password" id="multiPassword">
				<input type="hidden" name="urlServer" id="multiUrlServer">
				<input type="hidden" id="tbl_login_hidden" name="useTheSameIDAndPwd" />
			</form>
			<table class="tbl-action">
				<tr>
					<td class="lbl-input"></td>
					<td class="ntf-err-message" id="ntfErrMessage">
						<%=userBeanList.get(0) == null || userBeanList.get(0).getErrMessage() == null ? "" : userBeanList.get(0).getErrMessage() %>
					</td>
				</tr>
				<%if (userBeanList.size() > 1) {%>
				<tr id="tbl-action-checkbox-tr">
				<%} else {%>
				<tr id="tbl-action-checkbox-tr" style="display:none;">
				<%}%>
					<td colspan="2">
						<%if (useTheSameIDAndPwd != null && Boolean.parseBoolean(useTheSameIDAndPwd)) { %>
							<input id="tbl-action-checkbox" style="width:30px;border:none;" type="checkbox" value="true" checked="checked" />
						<%} else {%>
							<input id="tbl-action-checkbox" style="width:30px;border:none;" type="checkbox" value="true" />
						<%} %>
						<label for="tbl-action-checkbox"><fmt:message key="login.useTheSameIDAndPwd"/></label>
					</td>
				</tr>
				<tr>
					<td colspan="2" id="tbl-action-button">
						<button id="btn_login"><fmt:message key="login"/></button>
						<button id="btn_clear"><fmt:message key="clear"/></button>
						<button id="btn_url_add"><fmt:message key="login.url.add"/></button>
						<%if (userBeanList.size() > 1) { %>
						<button id="btn_url_delete">
						<%} else {%>
						<button id="btn_url_delete" disabled="disabled">
						<%}%>
							<fmt:message key="login.url.delete"/>
						</button>
					</td>
				</tr>
			</table>
			<script type="text/javascript">
				var td = document.getElementById("tbl-action-button");
				var tdWidth = td.offsetWidth;
				// 415:背景図の広さ、25:背景図の空白部分の広さ、tdWidth:tdの実際の広さ
				$(".tbl-action").css("margin-left", (415 - 25 - tdWidth)/2 + "px");
				// ブラウザはIEの場合
				if(navigator.userAgent.indexOf("MSIE") > 0) {
					$(".url-server-td").css("position", "relative");
					$(".urlList").css("top", "6px");
				}
				// 「同じユーザＩＤ・パスワードを使用する」チェックボックスは選択されていると、一番上の枠以外のユーザＩＤ・パスワードがグレーアウトされる。
					
				var useTheSameIDAndPwd = function() {
					var userNameInputs = document.getElementsByName("userNameInput");
					var passwordInputs = document.getElementsByName("passwordInput");
					if ($("#tbl-action-checkbox").attr("checked")) {
						for (var i = userNameInputs.length - 1; i >= 1; --i) {
							userNameInputs[i].readOnly="readonly";
							passwordInputs[i].readOnly="readonly";
							userNameInputs[i].className="input-readonly";
							passwordInputs[i].className="input-readonly";
						}
					} else {
						for (var i = userNameInputs.length - 1; i >= 1; --i) {
							userNameInputs[i].readOnly="";
							passwordInputs[i].readOnly="";
							userNameInputs[i].className="input-normal";
							passwordInputs[i].className="input-normal";
						}
					}
				};
				useTheSameIDAndPwd();
			</script>
		</div>
		<div id="frm-login-footer"></div>
		</center>
	</div>
	<div class="ui-layout-south">
		<fmt:message key="copyrightText"/>
	</div>
	<input type="hidden" id='login_text_user_id' value='<fmt:message key="user.id" />'>
	<input type="hidden" id='login_text_password' value='<fmt:message key="password" />'>
	<input type="hidden" id='login_text_connection_url' value='<fmt:message key="connection.url" />'>
	<input type="hidden" id='login_input_user_id' value='<%=AccessControlConstants.HINEMOS_USER_DEFAULT%>'>
	<input type="hidden" id='login_input_connection_url' value='<%=AccessControlConstants.HINEMOS_HTTP_PROTOCAL_DEFAULT + request.getLocalAddr() + AccessControlConstants.HINEMOS_HTTP_PORT_DEFAULT%>'>
	<%
	if (urlList != null) {
		for (int j = 0; j < urlList.size(); ++j) {
	%>
		<input type="hidden" value="<%=urlList.get(j) %>" class="url_list_hidden"/>
	<%
		}
	}
	%>
</body>
</html>