/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create node of repository
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	 var view = $.extend({}, __._fnview_grid, {
		 /*
		 * Update data for assignedScopes
		 */
		updateAssignedScopes: function(facility_id, facility_name, managerIp){
			var vw_dtl;
			
			// Check whether view "assigned scopes" exists
			if(!(vw_dtl = _pers["assigned_scopes"])){
				return;
			}
			
			// Update data for view detail
			vw_dtl.updateData({
				facility_id   : facility_id
				,facility_name: facility_name,
				manager_ip  : managerIp
			});
		}
		
		,/*
		 * Update data for node property
		 */
		updateNodeProperty: function(facility_id, managerIp){
			var vw_dtl;
			
			// Check whether view "node property" exists
			if(!(vw_dtl = _pers["node_property"])){
				return;
			}
			
			// Update data for view detail
			vw_dtl.updateData({
				facility_id: facility_id,
				manager_ip  : managerIp
				});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_node_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid = _.grid
					,pager   = grid.$pgr
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url         : "get_node_list"
						,pager      : pager
						,caption    : "&nbsp;"
						,viewrecords: true
						,onSelectRow: function(row_id){
							var i          = this
							,row_data      = $(i).getRowData(row_id)
							,facility_id   = $.jgrid.htmlEncode(row_data.facilityId)
							,facility_name = $.jgrid.htmlEncode(row_data.facilityName)
							,managerIp = $.jgrid.htmlEncode(row_data.manager);
							
							_.updateAssignedScopes(facility_id, facility_name, managerIp);
							_.updateNodeProperty(facility_id, managerIp);
                            
						}
						,loadComplete: function() {
							// Reload Repository[AssignedScopes] and Repository[NodeProperty] after 
							// Repository[Node] loaded
							var curent_facility_id   = _pers["assigned_scopes"].__facility_id;
							var manager_ip = _pers["assigned_scopes"].__manager_ip;
							
							if (curent_facility_id !== undefined && curent_facility_id.length > 0) {
								var in_node;
								if (manager_ip && manager_ip != "") {
									in_node = $(grid).find('tr').filter(function(){
										return ($(this).find('td:first-child').first().text() == curent_facility_id && 
												$(this).find('td:last-child').first().text() == manager_ip);
									});
								} else {
									in_node = _.grid.find("td:first-child").filter(function(){
										return $(this).text() == curent_facility_id;
									});
								}
								
								
								if (in_node.length > 0) {
									var row_id = $(in_node[0]).parent().attr('id');
									_.grid.jqGrid('setSelection',row_id);
								} else {
									_.updateNodeProperty('');
									_.updateAssignedScopes('', '');
								}
							}
						}
					});
				
					if (data_respond.colNames.length == 6) {
						grid.processData(data_respond, ['facilityId', 'manager']);
					} else {
						grid.processData(data_respond, ['facilityId']);
					}
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare filter dialog
			__.crePropActnDlg.call(
				_
				,"filter"
				,{
					option: {
						title   : _pers.getTitle("filter_nodes")
						,width  : 400
						,height : 330
						,open   : function(){
							$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(1)").focus();
						}
						,beforeClose : function() {
							_.filter.storeValues();
						}
						,buttons: [
							{
								text  : __.getLang("clear")
								,click: function(){
									_.filter.reset("filter");
								}
							}
							,{
								text  : __.getLang("ok_o")
								,click: function(){
									_.filter.execute(function(post_data){
										var _ = this;
										
										// Extend filter is true
										$.extend(post_data, {filter: true});
										
										// Refresh data
										_.grid.refreshData(post_data, true);
										
										// Store filter active
										_.filter_active = true;
										
										// Set caption
										_.grid.setCaption(__.getLang("filtered_list"));
										
										// Add class button active
										_.$btns.children("#filter").addClass("ui-button-active");
									});
									
									$(this).dialog("close");
								}
							}
							,{
								text  : __.getLang("cancel")
								,click: function(){
									_.filter.storeValues();
									$(this).dialog("close");
								}
							}
						]
					}
					,url  : "get_node_filter_property"
				}
			);
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			,_grid = _.grid
			;
			
			// Bind actions for button in left of pane
			// Bind filter
			_btns.children("#filter").click(function(){
				if(_.filter_active){
					// Inactive filter for filter grid
					_grid.refreshData({filter: false}, true);
					_grid.setCaption("&nbsp;");
					
					// Process CSS for button
					$(this).removeClass("ui-button-active");
					_.filter_active = false;
				}else{
					// Open dialog which contain filter property grid
					_.filter.open();
				}
			});
			
			// Bind update grid data
			_btns.children("#update").click(function(){
				_grid.refreshData(null, true);
			});
		}
	});
	
	return view;
};