/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor scope
 */
var fn = function(){
	var __ = cm;
	
	 var view = $.extend({}, __._fnview_grid, {
		 /*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_schedule_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid = _.grid;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url: "get_schedule"
					});
					
					if (data_respond.colNames.length == 13) {
						grid.processData(data_respond, ['scheId', 'manager']);
					} else {
						grid.processData(data_respond, ['scheId']);
					}
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
		}
	});
	
	return view;
};