/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Get and show data of job
 */
var fn = function(){
	var __    = cm
	,_pers     = this
	,load_tree = false
	,jobId     = ""
	,jobName   = ""
	,jobunitId = ""
	,sel_jobid = ""
	,manager_ip= ""
	;
	
	 var view = $.extend({}, __._fnview_tree_grid, {
		/*
		 * Set caption of grid
		 */
		setCaption: function(path, managerIp){
			if (managerIp == null || managerIp == "") {
				this.grid.setCaption([__.getLang("job"), ": " , path].join(""));
			} else {
				this.grid.setCaption([__.getLang("job"), "(", managerIp, "): " , path].join(""));
			}
		}
		
		,/*
		 * On click a node of tree
		 */
		onclickTree: function(node_data){
			var _ = this
			,grid = _.grid
			,data = []
			,children
			;
			
			// Get children of data
			if(node_data && (children = node_data.children)
					&& $.isArray(children)){
				var len = children.length;
				
				// Get jobData of children
				for(var cnt = 0; cnt < len; cnt++){
					data[cnt] = children[cnt].jobData;
				}
			}
			
			// Clear grid data before setting new data for grid
			grid.clearGridData();
			grid.setGridParam({data: data}).trigger("reloadGrid");
			
			// Set caption
			_.setCaption(node_data.path, node_data.managerIp);
		}
		
		,/*
		 * On query a node of tree
		 */
		onQueryActivate: function(node_data){
			var _ = this
			,$btns  = _.$btns
			,$mn = _.tree.siblings("#menu_rightclick_tree").children("ul:first")
			;
			
			// Store jobId, jobName, jobunitId
			jobunitId = node_data.jobunitId;
			jobId     = node_data.jobId;
			if (jobId != "") {
		 		jobName = node_data.jobData.jobName;
			}
			manager_ip = node_data.managerIp;
			
			// Check for setting status of run button
			if((jobId != "")
				&& ($.trim(node_data.addClass) != "dynatree-ico-forbidden_jobunit")){
				$btns.children("#runjob").attr("disabled", false);
				$btns.children("#runjob").removeClass("ui-state-default");
				$mn.children("#runjob").removeClass("ui-state-disabled");
			}else{
				$btns.children("#runjob").attr("disabled", true);
				$btns.children("#runjob").addClass("ui-state-default");
				$mn.children("#runjob").addClass("ui-state-disabled");
			}
			
			return true;
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_job_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,$mn = grid.siblings("#menu_rightclick").children("ul:first")
					,tree_index = -1
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						datatype: "local"
						,caption: [__.getLang("job"), ": "].join("")
						,loadComplete   : function(){
							var curent_job_id = sel_jobid;

							if (curent_job_id !== undefined && curent_job_id.length > 0) {
								var in_job_list = $(grid).find('tr').filter(function(){
									return ($(this).find('td:nth-child(1)').first().text() == curent_job_id);
								});
								
								if (in_job_list.length > 0){
									var row_id = $(in_job_list[0]).attr('id');
									grid.jqGrid('setSelection',row_id);
								} else {
									sel_jobid = "";
								}
							} else {
								sel_jobid = "";
							}
						}
						,onSelectRow     : function(row_id, e){
							var selrows = grid.getGridParam("selrow")
							,length = selrows.length
							,$btns  = _.$btns
							;
							
							// Store jobID, jobName
							jobId = grid.getCell(selrows, "jobId");
							jobName = $.jgrid.htmlEncode(grid.getCell(selrows, "jobName"));
							sel_jobid = jobId;
							tree_index = -1;
							
							// Check for select root case
							if (jobunitId == ""){
								var tree_data = _.getTree()
								,len
								,selected_tree;
								if (tree_data.children) {
									selected_tree = tree_data;
								} else {
									selected_tree = tree_data[0];
									for (var i = 0; i < tree_data.length; i++) {
										if (manager_ip == tree_data[i].managerIp) {
											selected_tree = tree_data[i];
											break;
										}
									}
								}
								
								len = selected_tree.children.length;
								for(var cnt = 0; cnt < len; cnt++){
									var child = selected_tree.children[cnt];
									if (jobId == child.jobunitId){
										
										if ($.trim(child.addClass) == "dynatree-ico-forbidden_jobunit"){
											tree_index = cnt;
										}
										break;
									}
								}
							}
							
							// Check for setting status of run button and run menu
							if((length != 1)
									&& (tree_index == -1)){
								$btns.children("#runjob").attr("disabled", false);
								$btns.children("#runjob").removeClass("ui-state-default");
							}else{
								$btns.children("#runjob").attr("disabled", true);
								$btns.children("#runjob").addClass("ui-state-default");
							}
						}
					});
					
					grid.processData(data_respond);
					grid.controlSize();
					
					// Bind context menu for grid (right click)
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu: function(event, menu){
								var row_id = $(event.target).closest("tr").attr("id")
								;
								
								// Reset jobID, jobName
								jobId = "";
								jobName = "";
								
								// After this action happen, it will call onSelectRow
								grid.jqGrid("setSelection", row_id, true);
								
								// Set status run menu
								if ((jobId != "") 
										&& (tree_index == -1)){
									$mn.children("#runjob").removeClass("ui-state-disabled");
								}else{
									$mn.children("#runjob").addClass("ui-state-disabled");
								}
								
								return true;
							}
							,container   : grid.$ctn
							,bindings    : {
								runjob: function(e){
									var msgContent;
									msgContent = __.getLang("run_job_confirm");
									msgContent = msgContent.replace("「{0}」", "「" + jobName + "」"); // 日本語の場合
									msgContent = msgContent.replace("{0}", "\"" + jobName + "\"");     // 英語の場合
									msgContent = msgContent.replace("{1}", jobId);
									msgContent = msgContent.replace("{2}", (jobunitId == "") ? jobId : jobunitId);
									
									__.openConfirmDlg(
											{
												title   : __.getLang("confirmed")
												,content: msgContent
											}
											,_.runJob
										);
									return true;
								}
							}
						}
					);
				}
				,error   : __.loadDataError
			});
			if(load_tree == false)
			{
				load_tree = _.update(_);
			}
		}
		
		,/*
		 * Get job tree
		 */
		getTree: function(){
			return _pers.job_tree.get();
		}
		
		,/*
		 * Update data for tree 
		 */
		update: function(_){
			
			__.jobmanagement.list.content.tree.append($("<div class='tree-loading'></div>"));
			_pers.job_tree.getData();
			
			return true;
		}
		
		,/*
		 * Run job
		 */
		runJob: function(){
			// Run action
			var post_data = {
					jobunitId: (jobunitId == "") ? jobId : jobunitId
					,jobId   : jobId
					,managerIpForSearch:manager_ip
					,action  : "runjob"
			};
			$.ajax({
				url      : "run_job"
				,cache   : false
				,dataType: "json"
				,type    : "post"
				,data    :  post_data
				,success : function(data_respond){	
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind toggle left pane
			_btns.children("#toggle_view").click(function(){
				_.togglePane("west", this);
			});
			
			// Run
			_btns.children("#runjob").click(function(){
				var msgContent;
				msgContent = __.getLang("run_job_confirm");
				msgContent = msgContent.replace("「{0}」", "「" + jobName + "」"); // 日本語の場合
				msgContent = msgContent.replace("{0}", "\"" + jobName + "\"");     // 英語の場合
				msgContent = msgContent.replace("{1}", jobId);
				msgContent = msgContent.replace("{2}", (jobunitId == "") ? jobId : jobunitId);
				
				__.openConfirmDlg(
						{
							title   : __.getLang("confirmed")
							,content: msgContent
						}
						,_.runJob
					);
			});
			
			// Bind context menu for grid (right click)
			_.tree.contextMenu(
				"menu_rightclick_tree"
				,{
					onContextMenu: function(event, menu){
						
						// Check right mouse on Job Node
						if (($.trim(event.target.className) != "dynatree-title") 
								&& ($.trim(event.target.className) != "dynatree-icon")) {
							return false;
						}
						
						// After this action happen, it will select target 
						event.target.click();
						
						return true;
					}
					,container   : _.tree.$ctn
					,bindings    : {
						runjob: function(e){
							var msgContent;
							msgContent = __.getLang("run_job_confirm");
							msgContent = msgContent.replace("「{0}」", "「" + jobName + "」"); // 日本語の場合
							msgContent = msgContent.replace("{0}", "\"" + jobName + "\"");     // 英語の場合
							msgContent = msgContent.replace("{1}", jobId);
							msgContent = msgContent.replace("{2}", (jobunitId == "") ? jobId : jobunitId);
							
							__.openConfirmDlg(
									{
										title   : __.getLang("confirmed")
										,content: msgContent
									}
									,_.runJob
								);
							return true;
						}
					}
				}
			);
		}
	});
	
	return view;
};