/*******************************************************************************
 * Declare function of views
 */
cm._fnview = {
	/********************************************************
	 * Ids for DOMs
	 */
	/*
	 * Get id (form) of from element
	 */
	ele2Id: function(p_ele){
		return [p_ele, "_", this._id].join("");
	}
		
	,/*
	 * Get container id (form) 
	 */
	getCtnId: function(p_nm){
		return [p_nm, "_ctn_", this._id].join("");
	}
	
	,/********************************************************
	 * Control view properties
	 */
	/*
	 * Action for button which handle toggle a view o layout
	 */
	togglePane: function(direction, button){
		// Control
		var _ = this
		;
		_.$layout.data("layout").toggle(direction);
		$(button).toggleClass("ui-button-active");
	}
	
	,/*
	 * Resize elements of view
	 */
	resizeInner: function(){
		var _  = this
		,comps = _._comps
		,comp
		;
		
		for(var l_len = comps.length; l_len--;){
			comp = comps[l_len];
			if(_[comp] && _[comp].controlSize){
				_[comp].controlSize();
			}
		}
	}
	
	,/*
	 * Cache DOM data frequently use, abstract
	 */
	cacheDom: function(){
		var _   = this
		,doms   = {}
		,comps  = _.setComp()
		,_comps = []
		,len
		;
		
		if(!(comps && $.isArray(comps) && (len = comps.length))){
			return false;
		}
		
		while(len--){
			var comp = comps[len];
			
			// Check validation of component
			if(!($.isArray(comp) && (comp.length == 2))){
				return false;
			}
			
			// Push value 'name' to component
			var name = comp[0];
			_comps.push(name);
			
			// Cache DOM
			var dom = doms[name] = _[comp[1]](name);
			
			// Add id for container
			dom.$ctn.attr("id", _.getCtnId(name));
			dom.attr("id", _.ele2Id(name));
		}
		
		// Add extend doms and comps for view
		$.extend(_, doms, {_comps: _comps});
		
		return true;
	}
	
	,/********************************************************
	 * Cache function
	 */
	/*
	 * Tree form
	 */
	cacheTree: function(p_name){
		var _ = this
		,_ctn = _.$ctn
		,tree
		,ctn
		;
		
		// Get component
		tree = _ctn.find(["#", p_name].join(""));
		ctn  = tree.parent();
		
		// Cache container and control size
		$.extend(tree, {
			$ctn        : ctn
			,controlSize: function(){
				var i = this
				,ctn  = i.$ctn
				;
				
				i.width(ctn.width());
				i.height(ctn.height());
			}
			,processData: function(p_opts, tree_data){
				var i      = this
				,options   = $.extend(
					{}
					,{
						clickFolderMode: 1
						,children      : tree_data
					}
					,p_opts
				)
				;
				
				i.dynatree(options);
			}
			,refreshData: function(tree_data){
				// Declare local variant
				var i = this
				,tree = i.dynatree("getTree")
				;
				
				// Renew tree
				tree.options.children = tree_data;
				tree.reload();
			}
		});
		
		return tree;
	}
		
	,/*
	 * Grid form
	 */
	cacheGrid: function(p_name){
		var _ = this
		,_ctn = _.$ctn
		,grid
		,ctn
		,pager_name = [p_name, "_pager"].join("")
		,pager
		;
		
		// Get component
		grid  = _ctn.find(["#", p_name].join(""));
		ctn   = grid.parent();
		pager = ctn.children(["#", pager_name].join(""));
		
		// Check pager
		if(pager.length !== 0){
			// Set pager
			pager.attr("id", _.ele2Id(pager_name));
			grid.$pgr = pager;
		}
		
		// Cache container
		$.extend(grid, {
			selected_rows  : null // store information of highlight rows
			,$ctn          : ctn
			,controlSize   : function(){
				var i = this
				,ctn  = i.$ctn
				,w    = ctn.width()
				,pg_h = 0
				;
				// Get height of pager
				if(i.$pgr){
					pg_h = i.$pgr.outerHeight(true);
				}
				
				/** Bug_21 */
				// Calculate values of height and width "thead:first tr.ui-jqgrid-labels"
				var h = ctn.height() - 1 -
						(
							$(i[0].grid.hDiv).outerHeight(true) // Header
							+$(["#gview_", i[0].id  ," > div.ui-jqgrid-titlebar:visible"].join("")
									,ctn).outerHeight(true) + // Caption
							pg_h
						);
				/**********/
				
				// Check height
				if(h < 1){
					h = 1;
				}
				
				// Set size of grid
				i.setGridWidth(w, false);
				i.setGridHeight(h, false);
			}
		
			// <ATTENTION> FIXED BUG_11: GRID
			,processData   : function(p_opts, p_keys, p_keys_fmt){
				// Get load complete
				var i           = this
				,__             = cm
				,options        = {
					datatype    : "json"
					,hidegrid   : false
					,shrinkToFit: false
					,pgbuttons  : false
					,scroll     : true
					,scrollrows : true
					,pgtext     : ""
					,mtype      : "POST"
					,loadError  : __.loadDataError
				}
				,more_opts      = {}
				;
				
				if (p_opts.treeGrid == true) {
					options.scroll = false;
				}
				
				// Reconstruct method "loadComplete"
				if(p_opts.loadComplete){
					var loadComplete = p_opts.loadComplete;
					more_opts.loadComplete = function(data_respond){
						// Default loadComplete
						i.loadComplete(data_respond);
						
						// Private option
						loadComplete.call(this, data_respond);
					};
				}else{
					more_opts.loadComplete = function(data_respond){
						// Only default action
						i.loadComplete(data_respond);
					};
				}
				
				// Reconstruct method "onSortCol"
				if(p_opts.onSortCol){
					var onSortCol = p_opts.onSortCol;
					more_opts.onSortCol = function(index, iCol, sortorder){
						// Default onSortCol
						i.onSortCol(index, iCol, sortorder);
						
						// Private option
						onSortCol.call(this, index, iCol, sortorder);
					};
				}else{
					more_opts.onSortCol = function(index, iCol, sortorder){
						// Only default action
						i.onSortCol(index, iCol, sortorder);
					};
				}
				
				// Check keys parameter, if keys is set meaning, it is necessary
				// to retain the highlight property of grid
				if(p_keys && ($.isArray(p_keys))){
					i.selected_rows = {
						header: p_keys
					};
					
					if (p_keys_fmt) {
						i.selected_rows.format = p_keys_fmt;
					}
					
					if(p_opts.multiselect){
						i.getRowSelected = i.getRowSelectedMulti;
					//	i.afterInsertRow = i.afterInsertRowMulti;
					}else{
						i.getRowSelected = i.getRowSelectedSingle;
					//	i.afterInsertRow = i.afterInsertRowSingle;
					}
					
					// Check afterInsertRow
					if(p_opts.afterInsertRow){
						var afterInsertRow = p_opts.afterInsertRow;
						more_opts.afterInsertRow = function(rowid, rowdata, rowelem){
							// Default action
							i.afterInsertRow(rowid, rowdata);
							
							// Private action
							afterInsertRow.call(this, rowid, rowdata, rowelem);
						};
					}else{
						more_opts.afterInsertRow = function(rowid, rowdata, rowelem){
							i.afterInsertRow(rowid, rowdata);
						};
					}
				}
				
				// Extend options
				$.extend(options, p_opts, more_opts);

				// Call constructor jqGrid
				i.jqGrid(options);
				
				// Bind action hide contextMenu, when click grid and it's header
				i.click(__.hideDefaultNoneDisplay);
				$("thead:first tr.ui-jqgrid-labels > th > div",
						grid[0].grid.hDiv).click(__.hideDefaultNoneDisplay);
			}
			,refreshData   : function(post_data, reselected){
				var i = this
				;
				
				// Check weather prevent load grid
				if(i._stop){
					return;
				}
				
				// Check select_rows
				if(i.selected_rows){
					// Get rows selected
					i.getRowSelected(reselected);
				}
				
				if(post_data){
					i.jqGrid("setGridParam", {postData: post_data});
				}
				
				i.trigger("reloadGrid");
			}
			,onSortCol: function(index, iCol, sortorder) {

				this.getRowSelected(true);
			}
			
			,/*
			 * Default action loadComplete for HINEMOS
			 */
			loadComplete   : function(data_respond){
				var i = this
				,check_value
				;
				
				// Check validation of data_respond
				if(i.getGridParam("datatype") == "json"){
					if ((check_value = cm.checkJsonError(data_respond))
						=== false){
						return;
					}
					
					// Prevent for load grid
					if(check_value !== true){
						i._stop = true;
						if((i.getGridParam("postData").action == "confirmed")
								|| (i.getGridParam("postData").action == "unconfirm")
								|| (i.getGridParam("postData").action == "batchconfirm")){
							i._stop = false;
						}
					}
					
				}
			}
			
			,/*
			 * Get selected (highlight) row(s)
			 * This function is interface, it will be constructed by pointing to
			 * "getRowSelectedSingle" or "getRowSelectedMulti" depend on the
			 * property "multiselect" of grid
			 */
			getRowSelected      : function(reselected){}
			,/*
			 * Get selected (highlight) row
			 * This function is called when refreshing data and it is necessary
			 * to retain information of the highlighted row (none multiselect)
			 */
			getRowSelectedSingle: function(reselected){
				this.getAllRowSelected(reselected);
			}
			,/*
			 * Get selected rows
			 * This function is called when refreshing data and it is necessary
			 * to retain information of the highlighted row (none multiselect)
			 */
			getRowSelectedMulti: function(reselected){
				this.getAllRowSelected(reselected, true);
			}
			,/*
			 * Get selected rows
			 */
			getAllRowSelected: function(reselected, multi){
				var i = this
				,selected_rows = i.selected_rows;
				;
				
				// Set null selected
				if(reselected !== true){
					selected_rows.data = null;
					return;
				}
				
				var data = []
				,row_ids
				;
				
				if(multi) {
					row_ids = i.getGridParam("selarrrow");
				} else {
					row_ids = [i.getGridParam("selrow")];
				}
				
				if(row_ids.length > 0){
					var header = selected_rows.header
					,row_data
					,count
					;
					
					for (var k = 0, j = row_ids.length; k < j; k++) {
						row_data = $(i).getRowData(row_ids[k]);
						count = header.length;
						var sel_data = [];
						
						while(count--){
							sel_data[count] = row_data[header[count]];
						}
						data[data.length] = sel_data;
					}
				}

				selected_rows.data = data;
			}
			
			,/*
			 * Set selected (highlight) row(s) again
			 * property "multiselect" of grid
			 */
			afterInsertRow      : function(rowid, rowdata){
				var i = this
				,selected_rows = i.selected_rows
				,header        = selected_rows.header
				,format		   = selected_rows.format
				,check_data
				,check
				,count
				,datas
				,data
				;
				
				if(!(datas = selected_rows.data)){
					return false;
				}

				for (var k = 0, j = datas.length; k < j; k++) {
					count = header.length;
					data  = datas[k];
					check = true;

					while(count--){
						check_data = rowdata[header[count]];
						if (format && format[header[count]] && format[header[count]]) {
							if (format[header[count]] == 'hnmDatetime') {
								check_data = $.fn.fmatter.hnmDatetime(check_data);
							}
						}
						
						check_data = $("<div/>").html(check_data).text();

						if(data[count] != check_data){
							check = false;
							break;
						}
					}
					
					if(check){
						i.jqGrid("setSelection", rowid, false);
						break;
					}
				}
			}
		});
		
		return grid;
	}
	
	/********************************************************
	 *
	 * Main actions
	 */
	,/*
	 * Initialize
	 */
	init: function(){
		// Cache local variant
		var _ = this;
		
		// Cache DOM (processed in fnComponent.js)
		_.cacheDom();
		
		// Create scope layout (processed in fnViewLayout.js)
		_.createLayout();
		
		// Load data (processed in fnViewLayout.js)
		_.loadData();
		
		// Create dialogs (processed in private files)
		if(_.createDialog){
			_.createDialog();
		}
		
		// Bind some action (processed in private file)
		_.bindAction();
	}
};
