/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Configuration
 */
(function(__){
	var config = {
		interval_jobmanagement_history: 600000
		,interval_monitor_scope       : 600000
		,interval_monitor_status      : 600000
		,interval_monitor_event       : 600000
	};
	
	__.config = function(key, value){
		var cur_value; // current value
		
		// Check key
		if(!key){
			return false;
		}
		
		// Check and get value of key
		if(!(cur_value = config[key])){
			return false;
		}
		
		// Check whether parameter 'value' is defined
		if((value === undefined) || (value === null)){
			// This is case getting value
			return cur_value;
		}
		
		// This is case setting value
		// Check type
		if((typeof cur_value) != (typeof value)){
			return false;
		}
		
		config[key] = value;
		return true;
	};
})(cm);
