/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * On Ready
 */
$(document).ready(function(){
	var split_for_multi_login = ",";

	/**
	 * 接続先URLが重複しているかどうかをチェックする関数
	 */
	var isUrlDublicated = function(array) {
		var flag = false;
		for (var i = 0; i < array.length; ++i) {
			for (var j = i + 1; j < array.length; ++j) {
				if (array[i] == array[j]) {
					flag = true;
					break;
				}
			}
			if (flag) {
				break;
			}
		}
		return flag;
	};

	var trimSpace = function(string) {
		var start = 0;
		var end = string.length;
		while ((start < end) && (string.substring(start, start + 1) == "${FullSizeSpace}" || string.substring(start, start + 1) <= " ")) {
            start++;
        }
        while ((start < end) && (string.substring(end - 1, end) == "${FullSizeSpace}" || string.substring(end - 1, end) <= " ")) {
        	end--;
        }
        return ((start > 0) || (end < string.length)) ? string.substring(start, end) : string;
	};
	
	/**************************************************************************
	 * Functions is used for processing login
	 */
	var loginAction = function(){
		var err_msg = {
			user_null : "${message.accesscontrol.1}"
			,pass_null: "${message.accesscontrol.2}"
			,url_null : "${message.hinemos.9}"
			,url_dublicated: "${message.accesscontrol.26}"
		}
		,user_name_input  = $(":input[name=userNameInput]")
		,password_input   = $(":input[name=passwordInput]")
		,url_server_input = $(":input[name=urlServerInput]")
		,use_the_same_id__pwd = $("#tbl-action-checkbox")
		,user_name  = $("#multiUserName")
		,password   = $("#multiPassword")
		,url_server = $("#multiUrlServer")
		,tbl_login_hidden = $("#tbl_login_hidden")
		,ntf_error  = $("#ntfErrMessage");

		user_name.val("");
		password.val("");
		url_server.val("");
		if (!use_the_same_id__pwd.is(":hidden") && use_the_same_id__pwd.attr("checked")) {

			// 一番上の枠におけるユーザIDが空であるかどうかのチェック
			if (trimSpace(user_name_input[0].value) == "") {
				ntf_error.html(err_msg.user_null);
				return;
			}

			// 一番上の枠におけるパスワードが空であるかどうかのチェック
			if (password_input[0].value == "") {
				ntf_error.html(err_msg.pass_null);
				return;
			}

			for (var i = 0; i < url_server_input.length; ++i) {
				// 該当接続先URLが空であるかどうかのチェック
				if (trimSpace(url_server_input[i].value) == "") {
					ntf_error.html(err_msg.url_null);
					return;
				}
				url_server.val(url_server.val() + url_server_input[i].value);
				if (i != url_server_input.length - 1) {
					url_server.val(url_server.val() + split_for_multi_login);
				}
			}
			user_name.val(encodeURIComponent(user_name_input[0].value));
			password.val(encodeURIComponent(password_input[0].value));
			tbl_login_hidden.val(encodeURIComponent(use_the_same_id__pwd.val()));
		} else {
			for (var i = 0; i < url_server_input.length; ++i) {

				// 該当ユーザIDが空であるかどうかのチェック
				if (trimSpace(user_name_input[i].value) == "") {
					ntf_error.html(err_msg.user_null);
					return;
				}

				// 該当パスワードが空であるかどうかのチェック
				if (password_input[i].value == "") {
					ntf_error.html(err_msg.pass_null);
					return;
				}

				// 該当接続先URLが空であるかどうかのチェック
				if (trimSpace(url_server_input[i].value) == "") {
					ntf_error.html(err_msg.url_null);
					return;
				}

				url_server.val(url_server.val() + encodeURIComponent(url_server_input[i].value));
				user_name.val(user_name.val() + encodeURIComponent(user_name_input[i].value));
				password.val(password.val() + encodeURIComponent(password_input[i].value));
				if (i != url_server_input.length - 1) {
					url_server.val(url_server.val() + split_for_multi_login);
					user_name.val(user_name.val() + split_for_multi_login);
					password.val(password.val() + split_for_multi_login);
				}
			}
		}

		// 接続先URLが重複しているかどうかをチェックする
		var url_servers = url_server.val().split(split_for_multi_login);
		if (url_servers.length > 1 && isUrlDublicated(url_servers)) {
			ntf_error.html(err_msg.url_dublicated);
			return;
		}
		
		$("form:first").submit();
		
		return;
	};
	
	/*
	 * Clear parameters of input;
	 */
	var clearParameter = function(){
		// Clear inputs and error message
		$(":input[type=text]").val("");
		$(":input[type=password]").val("");
		$(":checkbox").attr("checked", false);
		useTheSameIDAndPwd();
		$("#ntfErrMessage").text("");
		$("select").val("");
	};
	
	// urlリストプルダウンの選択肢を取得する
	var getUrlList = function() {
		var option = "";
		$.each($(".url_list_hidden"), function(index, value) { 
			option += "<option value='" + value.value +"'>" + value.value +"</option>";
		});
		return option;
	};
	
	// ログイン先の追加
	var addLoginUrl = function() {
		var newLoginUrlHtml = '<tr><td colspan="2"><hr class="split_hr" /></td></tr>'
		+ 	'<tr>'
		+ '	<td class="lbl-input">' + $('#login_text_user_id').val() + ':</td>'
		+	'<td><input type="text" name="userNameInput" value="' + $('#login_input_user_id').val() + '" maxlength=64 /></td>'
		+ '</tr>'
		+ '<tr>'
		+ '	<td class="lbl-input">' + $('#login_text_password').val() + ':</td>'
		+ '	<td><input type="password" name="passwordInput" autocomplete="off" value="" maxlength=64 /></td>'
		+ '</tr>'
		+ '<tr>'
		+ '	<td class="lbl-input">' + $('#login_text_connection_url').val() + ':</td>'
		+ '	<td class="url-server-td">'
		+ '		<input style="width: 192px;" class="url-server-input" type="text" name="urlServerInput" value="' + $('#login_input_connection_url').val() + '" maxlength=100 />'
		+ '		<select class="urlList" onchange="this.previousSibling.previousSibling.value=this.options[this.selectedIndex].value;">'
		+ '		<option></option>'
		+ getUrlList();
		+ '		</select>'
		+ '</td>'
		+ '</tr>';
		$(".tbl-login").append(newLoginUrlHtml);
		// ボタン「ログイン先の削除」を有効にする
		$("#btn_url_delete").attr("disabled", false);
		// チェックボックスを表示する
		$("#tbl-action-checkbox-tr").show();
		// ブラウザはIEの場合
		if(navigator.userAgent.indexOf("MSIE") > 0) {
			$(".url-server-td").css("position", "relative");
			$(".urlList").css("top", "6px");
		}
		// 「同じユーザＩＤ・パスワードを使用する」が選択されている場合の処理
		useTheSameIDAndPwd();
	};
	
	// ログイン先の削除
	var delLoginUrl = function() {
		var hrs = $('.split_hr');
		var table = $(".tbl-login")[0];
		var trs = table.children[0].children;
		var hr = hrs[hrs.length - 1];
		for (var i = trs.length - 1; i >= 0; --i) {
			if (trs[i] == hr.parentNode.parentNode) {
				for (var j = trs.length - 1; j >= i; --j) {
					table.children[0].removeChild(trs[j]);
				}
				break;
			}
		}
		hrs = $('.split_hr');
		if (0 == hrs.length) {
			// ボタン「ログイン先の削除」を無効にする
			$("#btn_url_delete").attr("disabled", true);
			$(":checkbox").attr("checked", false);
			// チェックボックス非表示
			$("#tbl-action-checkbox-tr").hide();
			$("#tbl_login_hidden").val("");
		}
	};

	// Bind action
	$("#btn_login").click(loginAction);
	$("#btn_clear").click(clearParameter);
	$("#btn_url_add").click(addLoginUrl);
	$("#btn_url_delete").click(delLoginUrl);
	$("#tbl-action-checkbox").change(useTheSameIDAndPwd);
	
	// Bind action submit when press enter key
	$("#frm-login").keypress(function(e){
		var code= (e.keyCode ? e.keyCode : e.which);
		if(code == 13){
			loginAction();
		}
	});
	
	/**************************************************************************
	 * Process layout
	 */
	$("body").layout({
		north__spacing_open : 0
		,south__spacing_open: 0
		,north__size        : 0.15
		,south__size        : 0.07
		,enableCursorHotkey : false
		,showErrorMessages  : false
	});
});