/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.validator;

import java.io.Serializable;

public class ActionError implements Serializable {
    private static final long serialVersionUID = 884138651338606385L;

    /**
     * <p>
     * The message key for this message.
     * </p>
     */
    protected String key = null;

    /**
     * <p>
     * The replacement values for this mesasge.
     * </p>
     */
    protected Object[] values = null;

    // ----------------------------------------------------------- Constructors

    /**
     * <p>
     * Construct an action message with no replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     */
    public ActionError(String key) {
        this(key, null);
    }

    /**
     * <p>
     * Construct an action message with the specified replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     * @param value0
     *            First replacement value
     */
    public ActionError(String key, Object value0) {
        this(key, new Object[] { value0 });
    }

    /**
     * <p>
     * Construct an action message with the specified replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     * @param value0
     *            First replacement value
     * @param value1
     *            Second replacement value
     */
    public ActionError(String key, Object value0, Object value1) {
        this(key, new Object[] { value0, value1 });
    }

    /**
     * <p>
     * Construct an action message with the specified replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     * @param value0
     *            First replacement value
     * @param value1
     *            Second replacement value
     * @param value2
     *            Third replacement value
     */
    public ActionError(String key, Object value0, Object value1, Object value2) {
        this(key, new Object[] { value0, value1, value2 });
    }

    /**
     * <p>
     * Construct an action message with the specified replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     * @param value0
     *            First replacement value
     * @param value1
     *            Second replacement value
     * @param value2
     *            Third replacement value
     * @param value3
     *            Fourth replacement value
     */
    public ActionError(String key, Object value0, Object value1, Object value2,
            Object value3) {
        this(key, new Object[] { value0, value1, value2, value3 });
    }

    /**
     * <p>
     * Construct an action message with the specified replacement values.
     * </p>
     * 
     * @param key
     *            Message key for this message
     * @param values
     *            Array of replacement values
     */
    public ActionError(String key, Object[] values) {
        this.key = key;
        this.values = values;
    }

    // --------------------------------------------------------- Public Methods

    /**
     * <p>
     * Get the message key for this message.
     * </p>
     * 
     * @return The message key for this message.
     */
    public String getKey() {
        return (this.key);
    }

    /**
     * <p>
     * Get the replacement values for this message.
     * </p>
     * 
     * @return The replacement values for this message.
     */
    public Object[] getValues() {
        return (this.values);
    }

    /**
     * <p>
     * Returns a String in the format: key[value1, value2, etc].
     * </p>
     * 
     * @return String representation of this message
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buff = new StringBuffer();

        buff.append(this.key);
        buff.append("[");

        if (this.values != null) {
            for (int i = 0; i < this.values.length; i++) {
                buff.append(this.values[i]);

                // don't append comma to last entry
                if (i < (this.values.length - 1)) {
                    buff.append(", ");
                }
            }
        }

        buff.append("]");

        return buff.toString();
    }
}
