/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.necsoft.hinemos.webclient.accesscontrol.util.AccessEndpointWrapper;

/**
 * ログインマネージャクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class LoginManager {
    private static Log m_log = LogFactory.getLog(LoginManager.class);

    public static final int VALUE_HTTP_CONNECT_TIMEOUT = 10;

    public static final int VALUE_HTTP_REQUEST_TIMEOUT = 60;

    public EndpointManager endpointManager = null;
    /**
     * コンストラクタ
     * 
     * @version 2.0.0
     * @since 2.0.0
     */
    public LoginManager() {
        endpointManager = new EndpointManager();
    }

    /**
     * ログイン(接続先URLあり)
     * 
     * @param uid
     * @param password
     * @param url
     * @throws Exception
     * 
     * @version 2.0.0
     * @since 2.0.0
     */
    public void login(String uid, String password, String url) throws Exception {
        endpointManager.init(uid, password, url, VALUE_HTTP_CONNECT_TIMEOUT,
                VALUE_HTTP_REQUEST_TIMEOUT);
        try {
            // ログインチェック
            AccessEndpointWrapper.checkLogin(endpointManager);
        } catch (Exception e) {
            m_log.error("login " + e.getMessage());
            throw e;
        }
    }
}