/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import org.apache.log4j.Logger;

import com.necsoft.hinemos.webclient.lang.WebMessages;

public class LogUtils {

    /** Loggerオブジェクト */
    private Logger logger = null;

    /**
     * LogUtilsオブジェクトのインスタンスを取り込む
     * 
     * @param cls
     *            クラス名
     * @return　LogUtils　ログのオブジェクト
     */
    public static LogUtils getLogUtils(Class cls) {
        return new LogUtils(cls);
    }

    /**
     * LogWriterクラスのコンストラクタ
     * 
     * @param cls
     *            クラス名
     */
    private LogUtils(Class cls) {
        // Loggerオブジェクトを作成します
        logger = Logger.getLogger(cls);

    }

    public void debug(String msgId, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.debug(strMsg);
    }

    public void info(String msgId, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.info(strMsg);
    }

    public void warn(String msgId, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.warn(strMsg);
    }

    public void error(String msgId, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.error(strMsg);
    }

    public void fatal(String msgId, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.fatal(strMsg);
    }

    public void warn(String msgId, Throwable t, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.warn(strMsg, t);
    }

    public void error(String msgId, Throwable t, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.warn(strMsg, t);
    }

    public void fatal(String msgId, Throwable t, String... strParams) {
        String strMsg = doLoadMsg(msgId, strParams);
        logger.error(strMsg, t);
    }

    private String doLoadMsg(String msgId, String... strParams) {
        if (msgId == null) {
            return "";
        }
        return WebMessages.getString(msgId, strParams);
    }
}
