/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.util;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityNotFound_Exception;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import com.clustercontrol.ws.repository.RepositoryEndpoint;
import com.clustercontrol.ws.repository.RepositoryTableInfo;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.EndpointManager.EndpointSetting;

/**
 * Hinemosマネージャとの通信をするクラス。 HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class RepositoryEndpointWrapper {

    // ログ
    private static Log m_log = LogFactory
            .getLog(RepositoryEndpointWrapper.class);

    public static List<RepositoryTableInfo> getPlatformList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getPlatformList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getPlatformList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static NodeInfo getNode(String facilityId,
            EndpointManager endpointManager) throws FacilityNotFound_Exception,
            HinemosUnknown_Exception, InvalidRole_Exception,
            InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getNode(facilityId);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getNode(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getNodeScopeList(String facilityId,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getNodeScopeList(facilityId);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getNodeScopeList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<FacilityInfo> getFacilityList(String facilityId,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getFacilityList(facilityId);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getScopeList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<RepositoryTableInfo> getVmSolutionMstList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getVmSolutionMstList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getVmSolutionMstList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<String> getVmProtocolMstList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getVmProtocolMstList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getVmProtocolMstList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<RepositoryTableInfo> getHostList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getHostList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getHostList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getFilterNodeList(NodeInfo nodeInfo,
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getFilterNodeList(nodeInfo);
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getFilterNodeList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<NodeInfo> getNodeListAll(EndpointManager endpointManager)
            throws HinemosUnknown_Exception, InvalidRole_Exception,
            InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getNodeListAll();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getNodeListAll(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static List<AgentStatusInfo> getAgentStatusList(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                return endpoint.getAgentStatusList();
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getAgentStatusList(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static FacilityTreeItem getFacilityTree(
            EndpointManager endpointManager) throws HinemosUnknown_Exception,
            InvalidRole_Exception, InvalidUserPass_Exception, WebServiceException {
        WebServiceException wse = null;
        for (EndpointSetting endpointSetting : endpointManager
                .getRepositoryEndpoint()) {
            try {
                RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting
                        .getEndpoint();
                FacilityTreeItem item = endpoint.getFacilityTree();
                setTreeParent(item);
                return item;
            } catch (WebServiceException e) {
                wse = e;
                m_log.warn("getFacilityTree(), " + e.getMessage(), e);
                endpointManager.changeEndpoint();
            }
        }
        throw wse;
    }

    public static void setTreeParent(FacilityTreeItem item) {
        List<FacilityTreeItem> children = item.getChildren();
        for (FacilityTreeItem child : children) {
            child.setParent(item);
            setTreeParent(child);
        }
    }

	public static void restartAgent(ArrayList<String> facilityIdList, int agentCommand
			,EndpointManager endpointManager)
	        throws HinemosUnknown_Exception, InvalidRole_Exception, InvalidUserPass_Exception {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getRepositoryEndpoint()) {
			try {
				RepositoryEndpoint endpoint = (RepositoryEndpoint) endpointSetting.getEndpoint();
				endpoint.restartAgent(facilityIdList, agentCommand);
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("restartAgent(), " + e.getMessage(), e);
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
    
}
