/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.repository.AgentStatusInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.NodeInfo;
import com.necsoft.hinemos.webclient.repository.action.GetAgentListTableDefine;
import com.necsoft.hinemos.webclient.repository.action.GetNodeScopeTableDefine;
import com.necsoft.hinemos.webclient.repository.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;

/**
 * 表示用のリストに変換するクラス
 **/
public class ConvertListUtil {
    /**
     * ScopeInfoDataからArrayListに変更する
     * @param list
     * @return ArrayList<ArrayList<Object>>
     */
    public static ArrayList<ArrayList<Object>> scopeInfoDataListToArrayList(
            List<FacilityInfo> list) {

        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        Iterator<FacilityInfo> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> scope = new ArrayList<Object>();
            FacilityInfo scopeInfoData = itr.next();
           
            // ファシリティID
            scope.add(GetScopeListTableDefine.FACILITY_ID,
                    scopeInfoData.getFacilityId());
            
            // ファシリティ名
            scope.add(GetScopeListTableDefine.FACILITY_NAME,
                    scopeInfoData.getFacilityName());
            
            // 説明
            scope.add(GetScopeListTableDefine.DESCRIPTION,
                    scopeInfoData.getDescription());
                        
            result.add(scope);
        }

        return result;
    }
    
    /**
     * @param list
     */
    public static void sanitizeScopeInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            // ファシリティ名
            if (row.get(GetScopeListTableDefine.FACILITY_NAME) != null) {
                row.set(GetScopeListTableDefine.FACILITY_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScopeListTableDefine.FACILITY_NAME).toString()));
            }
            
            // 説明
            if (row.get(GetScopeListTableDefine.DESCRIPTION) != null) {
                row.set(GetScopeListTableDefine.DESCRIPTION,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetScopeListTableDefine.DESCRIPTION).toString()));
            }
        }
    }
    
    /**
     * This method used for convert repository of NodeInfo to array list.
     * 
     * @author hungcv
     * @version 1.0
     * @since 2011/12/14
     * @param listInfoData
     *            : ArrayList<NodeInfo>
     * @return ArrayList<ArrayList>
     */
    public static ArrayList<ArrayList<Object>> nodeInfoListToArrayList(
            List<NodeInfo> listInfoData) {

        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        Iterator<NodeInfo> itr = listInfoData.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> node = new ArrayList<Object>();
            NodeInfo nodeInfoData = itr.next();
            
            // ファシリティID
            node.add(GetNodeListTableDefine.FACILITY_ID,
                    nodeInfoData.getFacilityId());
            // ファシリティ名
            node.add(GetNodeListTableDefine.FACILITY_NAME,
                    nodeInfoData.getFacilityName());
            // OS名
            node.add(GetNodeListTableDefine.PLATFORM,
                    nodeInfoData.getPlatformFamily());
            if (nodeInfoData.getIpAddressVersion() == 6) {
                // IPアドレス v6
                node.add(GetNodeListTableDefine.IP_ADDRESS,
                        nodeInfoData.getIpAddressV6());
            } else {
                // IPアドレス v4
                node.add(GetNodeListTableDefine.IP_ADDRESS,
                        nodeInfoData.getIpAddressV4());
            }   
            // 説明
            node.add(GetNodeListTableDefine.DESCRIPTION,
                    nodeInfoData.getDescription());

            result.add(node);
        }

        return result;
    }
    
    /**
     * @param list
     */
    public static void sanitizeNodeInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(GetNodeListTableDefine.FACILITY_NAME) != null) {
                row.set(GetNodeListTableDefine.FACILITY_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetNodeListTableDefine.FACILITY_NAME).toString()));
            }
            
            if (row.get(GetNodeListTableDefine.DESCRIPTION) != null) {
                row.set(GetNodeListTableDefine.DESCRIPTION,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetNodeListTableDefine.DESCRIPTION).toString()));
            }
        }
    }
    
    public static ArrayList<ArrayList<Object>> agentInfoListToArrayList(
            List<AgentStatusInfo> list) {

        ArrayList<ArrayList<Object>> ret = new ArrayList<ArrayList<Object>>();
        Iterator<AgentStatusInfo> itr = list.iterator();

        while (itr.hasNext()) {
            ArrayList<Object> agent = new ArrayList<Object>();
            AgentStatusInfo agentInfoData = itr.next();
            
            agent.add(GetAgentListTableDefine.FACILITY_ID,
                    agentInfoData.getFacilityId());
            
            agent.add(GetAgentListTableDefine.FACILITY_NAME,
                    agentInfoData.getFacilityName());
            
            agent.add(GetAgentListTableDefine.STARTUP_TIME,
                    agentInfoData.getStartupTime());
            
            agent.add(GetAgentListTableDefine.LAST_LOGIN,
                    agentInfoData.getLastLogin());
            
            agent.add(GetAgentListTableDefine.NEW_OLD,
                    agentInfoData.isNewFlag());
            
            ret.add(agent);
        }

        return ret;
    }
    
    public static void sanitizeAgentInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            if (row.get(GetAgentListTableDefine.FACILITY_ID) != null) {
                row.set(GetAgentListTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetAgentListTableDefine.FACILITY_ID).toString()));
            }
            
            if (row.get(GetAgentListTableDefine.FACILITY_NAME) != null) {
                row.set(GetAgentListTableDefine.FACILITY_NAME,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetAgentListTableDefine.FACILITY_NAME).toString()));
            }
        }
    }
    
    /**
     * This method used for convert repository of NodeScopeInfo to array list.
     * 
     * @author hungcv
     * @version 1.0
     * @since 2011/12/14
     * @param listInfoData
     *            : ArrayList<?>
     * @return ArrayList<String>
     */
    public static ArrayList<ArrayList<Object>> convertNodeScopeInfoToList(
            List<String> listInfoData) {

        ArrayList<ArrayList<Object>> result = new ArrayList<ArrayList<Object>>();
        // Set rows
        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList<Object> infoData = new ArrayList<Object>();
            infoData.add(GetNodeScopeTableDefine.SCOPE, 
                    listInfoData.get(countRow) + "");
            result.add(infoData);
        }
        return result;
    }
    
    /**
     * @param list
     */
    public static void sanitizeNodeScopeInfoData(ArrayList<ArrayList<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            ArrayList<Object> row = list.get(count);

            // スコープ
            if (row.get(GetNodeScopeTableDefine.SCOPE) != null) {
                row.set(GetNodeScopeTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml4(row.get(
                                GetNodeScopeTableDefine.SCOPE).toString()));
            }
        }
    }
}