/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodePropertyBusiness;
import com.necsoft.hinemos.webclient.repository.form.NodePropertyForm;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for display data of NodeProperty view
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodePropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -4114731394349452014L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodePropertyServlet.class);

    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException, HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        try {
            //get data
            Property propertyNode = getNodeProperty(request);
            
            //convert to json
            result = DataProcess.doConvertNodePropertyToJson(propertyNode.getChildren());
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(), request.getLocale());
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        
        return result;
    }

    private Property getNodeProperty(HttpServletRequest request) throws HinemosWebException {
        // 中間変数を宣言
        NodePropertyForm form = new NodePropertyForm();
        Property result = null;
        PopulateBeanUtils.populateBean(form, request);
                
        //get loginManager session
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;
        synchronized(session) {
            loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            
            GetNodePropertyBusiness business = new GetNodePropertyBusiness();
            result = business.getNodeProperty(form, request.getLocale(), loginManager.endpointManager);
        }
        
        return result;
    }
}