/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;
import com.necsoft.hinemos.webclient.repository.business.GetNodeListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for display header of node view
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeListTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -975394539239284271L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeListTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        GetNodeListTableDefineBusiness business = null;
        
        try {
            //get data
            business = new GetNodeListTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = business.getNodeListTableDefine(request.getLocale());
       
            //convert to Json
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(), 
                    Constants.MAX_TABLE_ROW_NUM,
                    GetNodeListTableDefine.SORT_COLUMN_INDEX,
                    GetNodeListTableDefine.SORT_ORDER);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }
}