/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.action.GetAgentListTableDefine;
import com.necsoft.hinemos.webclient.repository.business.GetAgentListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for display header of agent view
 * 
 */
public class GetAgentListTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -975394539239284271L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetAgentListTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        GetAgentListTableDefineBusiness business = new GetAgentListTableDefineBusiness();
        
        try {
            //get data
            ArrayList<TableColumnInfoJs> tblDefine = business
                    .getAgentListTableDefine(request.getLocale());

            setModelProperties(tblDefine);

            //convert to json
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    Constants.MAX_TABLE_ROW_NUM,
                    GetAgentListTableDefine.SORT_COLUMN_INDEX,
                    GetAgentListTableDefine.SORT_ORDER);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(GetAgentListTableDefine.FACILITY_ID).
            setClasses(CssClass.GRID_FIRST_COLUMN);
        
        TableColumnInfoJs lastLogin = tblDefine
            .get(GetAgentListTableDefine.LAST_LOGIN);
        lastLogin.setFormatter(JsConstant.GRID_FMATTER_DATE_TIME);
        lastLogin.setClasses(CssClass.GRID_MARKER_CELL_DATE_TIME_PRECISE);
        
        TableColumnInfoJs startupTime = tblDefine
            .get(GetAgentListTableDefine.STARTUP_TIME);
        startupTime.setFormatter(JsConstant.GRID_FMATTER_DATE_TIME);
        startupTime.setClasses(CssClass.GRID_MARKER_CELL_DATE_TIME_PRECISE);
    
        tblDefine.get(GetAgentListTableDefine.NEW_OLD).setFormatter(
                JsConstant.GRID_FMATTER_UPDATE_TYPE);
    }
}
