/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.repository.form.ScopeListForm;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get data of Scope view
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScopeListBusiness {
    
    public ArrayList<ArrayList<Object>> getScopeList(ScopeListForm form, 
            EndpointManager endpointManager) throws HinemosWebException {
        
        // スコープ情報一覧データ(ScopeInfoData)を取得
        ArrayList<ArrayList<Object>> listInfoData = null;
        
        List<FacilityInfo> list = null;
        try {
            list = RepositoryEndpointWrapper.getFacilityList(
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()), endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }
        
        listInfoData = ConvertListUtil.scopeInfoDataListToArrayList(list);
        
        // Sanitize
        ConvertListUtil.sanitizeScopeInfoData(listInfoData);
        
        // Sort data
        DataProcess.sortData(form, listInfoData,
                GetScopeListTableDefine.SORT_COLUMN_INDEX_SECOND,
                GetScopeListTableDefine.SORT_ORDER,
                RepositoryConstants.SCOPE_LIST_TABLE_HEADER_NUM);
         
        return listInfoData;
    }
}