/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.ws.repository.NodeInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.action.GetNodeProperty;
import com.necsoft.hinemos.webclient.repository.form.NodePropertyForm;
import com.necsoft.hinemos.webclient.repository.util.NodePropertyUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get NodeProperty
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodePropertyBusiness {

    public Property getNodeProperty(NodePropertyForm form, Locale locale,
            EndpointManager endpointManager) throws HinemosWebException {

        GetNodeProperty nodeProperty = null;
        NodeInfo nodeInfo = null;
        Property propertyNode = null;

        nodeProperty = new GetNodeProperty();
        nodeInfo = nodeProperty.getProperty(
                StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                PropertyConstant.MODE_SHOW, locale, endpointManager);

        propertyNode = NodePropertyUtil.node2property(nodeInfo,
                PropertyConstant.MODE_SHOW, locale, endpointManager);
        
        return propertyNode;
    }
}