/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get data of Agent view
 * 
 */
public class AgentRestartBusiness {

    public void restartAgent(ArrayList<String> facilityIdList,
        	 int agentCommand, EndpointManager endpointManager) throws HinemosWebException {
            try {
                RepositoryEndpointWrapper.restartAgent(facilityIdList, agentCommand,endpointManager);
            } catch (InvalidRole_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (HinemosUnknown_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (InvalidUserPass_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (WebServiceException e) {
                // Hinemosマネージャより応答がありませんでした。ログアウトします。
                throw new HinemosWebException("message.force.disconnect");
            }
            return;
        }
    
}