/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.repository.util.RepositoryMappingUtil;

/**
 *登録スコープ一覧のテーブル定義を取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScopeListTableDefine {

	/** ファシリティID */
	public static final int FACILITY_ID = 0;

	/** ファシリティ名 */
	public static final int FACILITY_NAME = 1;

	/** 注釈 */
	public static final int DESCRIPTION = 2;

	/** ソート用データ**/
	public static final int SORT_VALUE=3;

	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX =SORT_VALUE ;

	public static final int SORT_COLUMN_INDEX_SECOND= FACILITY_ID;

	/** 初期表示時ソートオーダー */
	public static final int SORT_ORDER = 1;

	/**
     * スコープ一覧テーブル定義を取得します。
     * 
     * @return ノード一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale), 
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                RepositoryMappingUtil.getScopeName(FACILITY_ID)));
        tableDefine.add(FACILITY_NAME, new TableColumnInfoJs(
                WebMessages.getString("facility.name", locale), 
                TableColumnInfoJs.FACILITY_NAME, 150, SWT.LEFT,
                RepositoryMappingUtil.getScopeName(FACILITY_NAME)));
        tableDefine.add(DESCRIPTION, new TableColumnInfoJs(
                WebMessages.getString("description", locale), 
                TableColumnInfoJs.NONE, 200, SWT.LEFT, 
                RepositoryMappingUtil.getScopeName(DESCRIPTION)));

        return tableDefine;
    }
}