/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.monitor.business.GetScopeListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * GetScopeListTableDefineServlet
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScopeListTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -3895758389407649269L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetScopeListTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            ArrayList<TableColumnInfoJs> tblDefine = getScopeListTableDefine(request
                    .getLocale());

            setModelProperties(tblDefine);

            result = doConvertToJson(tblDefine, request.getLocale(),
                    Constants.MONITOR_SCOPE_ROW_NUM,
                    GetScopeListTableDefine.SORT_COLUMN_INDEX,
                    GetScopeListTableDefine.SORT_ORDER);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param locale
     * @return
     * @throws HinemosWebException
     */
    private ArrayList<TableColumnInfoJs> getScopeListTableDefine(Locale locale)
            throws HinemosWebException {
        return new GetScopeListTableDefineBusiness()
                .getScopeListTableDefine(locale);
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        // Set priority class
        TableColumnInfoJs priority = tblDefine.get(GetScopeListTableDefine.PRIORITY);
        priority.setClasses(CssClass.PRIORITY_CELL);
        priority.setFormatter(JsConstant.GRID_FMATTER_PRIORITY);

        TableColumnInfoJs scope = tblDefine.get(GetScopeListTableDefine.SCOPE);
        scope.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                GetScopeListTableDefine.FACILITY_ID);
        scope.setFormatoptions(scopeFmtOpt);
    }

    /**
     * @param tblDefine
     * @param locale
     * @return
     */
    private GridHeaderJson doConvertToJson(
            ArrayList<TableColumnInfoJs> tblDefine, Locale locale,
            int row_num, int column_index, int sort_order) {
        return DataProcess.doConvertTableDefineToJson(tblDefine, true, locale, row_num, column_index, sort_order);
    }
}