/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.Locale;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.form.EventInfoPropertyForm;
import com.necsoft.hinemos.webclient.monitor.util.EventDataPropertyUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

public class GetEventInfoPropertyBusiness {

    public Property getEventInfoProperty(EventInfoPropertyForm form, 
        Locale locale, EndpointManager endpointManager)throws HinemosWebException {
        Property propertyEvent = null;
        // イベント情報一覧を取得
        EventDataInfo info;

        try {
            info = MonitorEndpointWrapper.getEventInfo(
                    StringEscapeUtils.unescapeHtml4(form.getMonitorId()),
                    StringEscapeUtils.unescapeHtml4(form.getMonitorDetailId()),
                    StringEscapeUtils.unescapeHtml4(form.getPluginId()),
                    StringEscapeUtils.unescapeHtml4(form.getFacilityId()),
                    form.getReceiveTime(),
                    endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }
        
        propertyEvent = EventDataPropertyUtil.dto2property(info, locale);
        return propertyEvent;
    }
}
