/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.monitor.action.GetEventBatchConfirmProperty;

/**
 * 一括確認プロパティ情報一覧を取得するビジネスクラス
 */
public class GetEventBatchConfirmPropertyBusiness {

    public Property getEventBatchConfirmProperty(Locale locale)
            throws HinemosWebException {
        // 一括確認一覧を取得
        Property propertyEvent = null;
        GetEventBatchConfirmProperty getEventBatchConfirmProperty = new GetEventBatchConfirmProperty();
        propertyEvent = getEventBatchConfirmProperty.getProperty(locale);
        if (propertyEvent == null) {
                 // 一括確認一覧の取得に失敗しました
                 throw new HinemosWebInvalidDataException("exception.data.param");
        }
        return propertyEvent;
    }
}
