/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.Locale;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.EventBatchConfirmInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.bean.ConfirmConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.form.MonitorEventForm;
import com.necsoft.hinemos.webclient.monitor.util.EventBatchConfirmPropertyUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

/**
 * イベント情報を一括確認の処理を実行するビジネスクラス
 */
public class EventBatchConfirmBusiness {

    public boolean batchconfirm(MonitorEventForm form,
        Property condition, EndpointManager endpointManager, Locale locale) 
    throws HinemosWebException {
        
        // 一括確認の条件一覧データを取得
        if (condition != null) {
            try {
                PropertyUtil.deletePropertyDefine(condition);
                EventBatchConfirmInfo info = EventBatchConfirmPropertyUtil.property2dto(condition, locale);
                MonitorEndpointWrapper.modifyBatchConfirm(ConfirmConstant.TYPE_CONFIRMED, 
                        StringEscapeUtils.unescapeHtml4(form.getFacilityId()), info, endpointManager);
            } catch (InvalidRole_Exception e) {
                // アクセス権なしの場合
                return false;
            } catch (HinemosUnknown_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (InvalidUserPass_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (WebServiceException e) {
                // Hinemosマネージャより応答がありませんでした。ログアウトします。
                throw new HinemosWebException("message.force.disconnect");
            }
            
            return true;
        }
        return false;
    }
}
