/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.util.ArrayList;
import java.util.Locale;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.monitor.util.MonitorMappingUtil;

/**
 * 監視[スコープ]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScopeListTableDefine {
    /** 重要度。 */
    public static final int PRIORITY = 0;

    /** ファシリティID。 */
    public static final int FACILITY_ID = 1;

    /** スコープ。 */
    public static final int SCOPE = 2;

    /** 更新日時。 */
    public static final int UPDATE_TIME = 3;

    /** ソート用データ**/
    public static final int SORT_VALUE=4;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = SORT_VALUE;

    ///** 初期表示時ソートカラム。 */
    //public static final int SORT_COLUMN_INDEX_SECOND = FACILITY_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

    /**
     * 監視[スコープ]ビューのテーブル定義情報を取得します。<BR><BR>
     * リストに、カラム毎にテーブルカラム情報をセットします。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.bean.TableColumnInfo#TableColumnInfoJs(java.lang.String,int, int, int)
     * @see com.clustercontrol.monitor.bean.ScopeTabelDefine
     */
    public static ArrayList<TableColumnInfoJs> getScopeListTableDefine(
            Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(PRIORITY, new TableColumnInfoJs(
                WebMessages.getString("priority", locale),
                TableColumnInfoJs.PRIORITY, 55, SWT.LEFT,
                MonitorMappingUtil.getScopeName(PRIORITY)));
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale),
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                MonitorMappingUtil.getScopeName(FACILITY_ID)));
        tableDefine.add(SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale),
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                MonitorMappingUtil.getScopeName(SCOPE)));

        return tableDefine;
    }
}