/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebJobInfoNotFoundException;
import com.necsoft.hinemos.webclient.jobmanagement.business.RunJobBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.JobListForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * ジョブ[一覧]に選択したジョブを実行するサーブレットクラス 
 */
public class RunJobServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(RunJobServlet.class);

    /**
     * Run job
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {
        
        // 中間変数を宣言
        CommonJson result = new CommonJson();
        
        // Get data form
        JobListForm form = getDataForm(request);
        
        try {
            // Action form
            doAction(form, request);
            
        } catch (HinemosWebAccessException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_INFO, 
                    ex.getMessage(),
                    request.getLocale());
        } catch (HinemosWebJobInfoNotFoundException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            String message =  WebMessages.getString(ex.getMessage(), request.getLocale());
            message = message.replace("{0}", form.getJobunitId() + "." + form.getJobId());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, 
                    message,
                    request.getLocale());
        }
        catch (HinemosWebException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, 
                    ex.getMessage(),
                    request.getLocale());
        }
        
        return result;
    }
    
    /**
     * HTTPリクエストからフォーム情報を取得する
     * @param request
     * @return form
     */
    private JobListForm getDataForm(HttpServletRequest request) {
        JobListForm form = new JobListForm();
        PopulateBeanUtils.populateBean(form, request);
        return form;
    }
    
    /**
     * 選択したジョブの実行処理を行う
     * @param form
     * @param request
     * @throws HinemosWebException
     */
    private void doAction(JobListForm form, HttpServletRequest request) 
        throws HinemosWebException {
        // Check action
        if (form.getAction() != null) {
            if (form.getAction().equals("runjob")) {
                String jobunitId;
                String jobId;
                
                // Get jobunitId and jobId
                if (form.getJobunitId() == null || form.getJobId() == null) {
                    // 確認に失敗しました
                    throw new HinemosWebInvalidRequestParameterException(
                            "exception.data.run");
                } else {
                    jobunitId = form.getJobunitId();
                    jobId = form.getJobId();
                }
                
                HttpSession session = request.getSession(true);
                LoginManager loginManager = null;
                synchronized(session) {
                    loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
    
                    RunJobBusiness eventBusiness = new RunJobBusiness();
                    eventBusiness.runJob(jobunitId, jobId, loginManager.endpointManager);
                }
            }
        }
    }
}