/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryTableDefineServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();
        GetHistoryTableDefineBusiness business = null;
        try {
            //Get header list
            business = new GetHistoryTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = business.getHistoryTableDefine(request.getLocale());
            
            //Format column data
            setModelProperties(tblDefine);

            //Convert header to JSON structure
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    JobManagementConstants.MAX_HISTORIES,
                    GetHistoryTableDefine.SORT_COLUMN_INDEX,
                    GetHistoryTableDefine.SORT_ORDER);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(GetHistoryTableDefine.STATUS).setFormatter(
                JsConstant.GRID_FMATTER_RUN_STATUS);

        tblDefine.get(GetHistoryTableDefine.END_STATUS).setFormatter(
                JsConstant.GRID_FMATTER_END_STATUS);

        tblDefine.get(GetHistoryTableDefine.SCHEDULED_START_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetHistoryTableDefine.JOB_TYPE).setFormatter(
                JsConstant.GRID_FMATTER_JOB);

        TableColumnInfoJs scope = tblDefine.get(GetHistoryTableDefine.SCOPE);
        scope.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                GetHistoryTableDefine.FACILITY_ID);
        scope.setFormatoptions(scopeFmtOpt);

        tblDefine.get(GetHistoryTableDefine.START_RERUN_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetHistoryTableDefine.END_SUSPEND_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);
        
        tblDefine.get(GetHistoryTableDefine.TRIGGER_TYPE).setFormatter(
                JsConstant.GRID_FMATTER_TRIGGER_TYPE);
    }
}