/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.HistoryForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get History info
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryServlet.class);

    /**
     * Get History info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();

        try {
            // Get Data
            ArrayList<ArrayList<Object>> listInfoData = doLoadListInfoData(request);

            // Convert data to JSON structure
            result = DataProcess.doConvertTableContentToJson(listInfoData);
            
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(), request.getLocale());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * ジョブ[履歴]情報一覧データを取得
     */
    private ArrayList<ArrayList<Object>> doLoadListInfoData(HttpServletRequest request)
        throws HinemosWebException {
     
        // 中間変数を宣言
        HistoryForm form = new HistoryForm();
        ArrayList<ArrayList<Object>> list = null;

        PopulateBeanUtils.populateBean(form, request);
        
        //Get loginManager session
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;
        synchronized(session) {
            loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);        
         
            //Check filter
            if (form.isFilter()) {
                list = processFitler(request, form, loginManager.endpointManager);
            } else {
                list = processNoneFilter(request, form, loginManager.endpointManager);
            } 
        }
        return list;
    }
    
    private ArrayList<ArrayList<Object>> processFitler(HttpServletRequest request,
            HistoryForm form, EndpointManager endpointManager)
            throws HinemosWebException {
        Property condition = doLoadCondition(request);
        GetHistoryBusiness business = new GetHistoryBusiness();
        return business.getHistory(form, condition, endpointManager, request.getLocale());
    }

    private ArrayList<ArrayList<Object>> processNoneFilter(HttpServletRequest request,
            HistoryForm form, EndpointManager endpointManager) throws HinemosWebException {
        GetHistoryBusiness business = new GetHistoryBusiness();
        return business.getHistory(form, null, endpointManager, request.getLocale());
    }

    private Property doLoadCondition(HttpServletRequest request)
            throws HinemosWebException {

        GetHistoryFilterPropertyBusiness filterProperties = 
            new GetHistoryFilterPropertyBusiness();

        Property condition = filterProperties.getHistoryFilterProperty(request.getLocale());
        convertCondition(request, condition);

        return condition;
    }
}