/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobSchedule;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetScheduleTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.ScheduleForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get Schedule
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetScheduleBusiness {

    /**
     * スケジュール情報一覧データを取得
     */
    public ArrayList<ArrayList<Object>> getSchedule(ScheduleForm form, 
            EndpointManager endpointManager, Locale locale) throws HinemosWebException {

        ArrayList<ArrayList<Object>> listInfoData = null;
        List<JobSchedule> jobSchedule = null;
        
        try {
            jobSchedule = JobEndpointWrapper.getScheduleList(endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (JobMasterNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        //リストに変換する
        listInfoData = ConvertListUtil.jobScheduleListToArrayList(jobSchedule, locale);
        
        //Sanitize
        ConvertListUtil.sanitizeScheduleList(listInfoData);
        
        //Sort data
        DataProcess.sortData(form, listInfoData,
                GetScheduleTableDefine.SORT_COLUMN_INDEX,
                GetScheduleTableDefine.SORT_ORDER,
                JobManagementConstants.SCHEDULE_HEADER_NUM);
        
        return listInfoData;
    }
}