/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobNodeDetail;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetNodeDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.NodeDetailForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get Node Detail list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeDetailBusiness {

    /**
     * Get Node Detail list
     * 
     * @param form
     *            : NodeDetailForm
     * @param endpointManager
     *            : EndpointManager
     * @return ArrayList<JobNodeDetail>
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList<Object>> getNodeDetail(NodeDetailForm form,
            EndpointManager endpointManager) throws HinemosWebException {

        List<JobNodeDetail> listItem = null;

        try {
            listItem = JobEndpointWrapper.getNodeDetailList(
                    form.getSessionId(),
                    StringEscapeUtils.unescapeHtml4(form.getJobunitId()),
                    StringEscapeUtils.unescapeHtml4(form.getJobId()),
                    endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (JobInfoNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
                .jobNodeDetailListToArrayList(listItem);

        //Sanitize
        ConvertListUtil.sanitizeNodeDetailList(list);
        
        DataProcess.sortData(form, list,
                GetNodeDetailTableDefine.SORT_COLUMN_INDEX,
                GetNodeDetailTableDefine.SORT_ORDER,
                JobManagementConstants.NODE_HEADER_NUM);
        return list;
    }
}