/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Locale;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobHistoryList;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.HistoryForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobPropertyUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get History Business list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryBusiness {

    /**
     * ジョブ履歴一覧情報を取得する
     * 
     * @return 履歴一覧
     */
    public ArrayList<ArrayList<Object>> getHistory(HistoryForm form, Property condition,
            EndpointManager endpointManager, Locale locale) throws HinemosWebException{

        JobHistoryList listInfoData = null;
        try {
            if (condition == null) {
                //全ての履歴一覧を取得する                
                listInfoData = JobEndpointWrapper.getJobHistoryList(null, 
                        JobManagementConstants.MAX_HISTORIES, endpointManager);                
            } else {
                //Propertyの条件にヒットする履歴の一覧を取得する                
                listInfoData = JobEndpointWrapper.getJobHistoryList(
                        JobPropertyUtil.property2jobHistoryFilter(condition, locale),
                        JobManagementConstants.MAX_HISTORIES, endpointManager);
            } 
        }catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (JobInfoNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }
        
        ArrayList<ArrayList<Object>> list = ConvertListUtil.
                jobHistoryListToArrayList(listInfoData.getList());

        //Sanitize
        ConvertListUtil.sanitizeHistoryList(list);
        
        //Sort data
        DataProcess.sortData(form, list,
                GetHistoryTableDefine.SORT_COLUMN_INDEX,
                GetHistoryTableDefine.SORT_ORDER,
                JobManagementConstants.HISTORY_HEADER_NUM);

        return list;
    }
}