/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * イベント情報の確認状態の定義を定数として格納するクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ConfirmConstant {
    /** 確認（種別）。 */
    public static final int TYPE_CONFIRMED = 1;

    /** 未確認（種別）。 */
    public static final int TYPE_UNCONFIRMED = 0;

    /** 確認と未確認 */
    public static final int TYPE_ALL = -1;

    /**
     * 文字列から種別に変換します。<BR>
     * 
     * @param string 文字列
     * @return 種別
     */
    public static int stringToType(String string, Locale locale) {
        if (string.equals(WebMessages.getString("monitor.confirmed", locale))) {
            return TYPE_CONFIRMED; //確認（文字列）
        } else if (string.equals(WebMessages.getString("monitor.unconfirmed", locale))) {
            return TYPE_UNCONFIRMED; //未確認（文字列）
        }
        return TYPE_ALL;
    }
}