/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create agent of repository
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	
	 var view = $.extend({}, __._fnview_grid, {
		/*
		 * Get agent list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_agent_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid = _.grid
					,pager   = grid.$pgr
					,$mn = grid.siblings("#menu_rightclick").children("ul:first")
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url         : "get_agent_list"
						,pager      : pager
						,caption    : "&nbsp;"
						,viewrecords: true
						,multiselect     : true
						,loadComplete : function(){_.restartButtonDisable();}
						,onSelectRow : function(){_.restartButtonDisable();}
						,beforeSelectRow : function (row_id, e) {
							if (e.shiftKey) { // Select from a b
								if(grid.init_list_row_id === undefined){
									// init_list_row_id hasn't initialized yet
									grid.init_list_row_id = row_id;
									return true;
								}
								
								// row_id: type string
								var init_list_row_id = grid.init_list_row_id // type string
								,init_index   = grid.jqGrid("getInd", init_list_row_id) // type number
								,cur_index    = grid.jqGrid("getInd", row_id)
								,start_select = false
								;
								
								// Clear list selection
								grid.jqGrid("resetSelection");
								
								if(init_index == cur_index){
									return true;
								} else {
									if (init_index < cur_index) {
										$.each(grid.getDataIDs(), function(key, value){
											// value: type string
											if(value == row_id){
												// The end, not select this row
												//   which is on click because, this action will bind after
												return false;
											}
											
											if (start_select || (start_select = (value == init_list_row_id))){
												grid.jqGrid("setSelection", value, false);
											}
											
											return true;
										});
									} else {
										$.each(grid.getDataIDs(), function(key, value){
											if (start_select){
												grid.jqGrid("setSelection", value, false);
												return (value != init_list_row_id);
											}
											
											if(value == row_id){ // Start line: not set
												start_select = true;
											}
											return true;
										});
									}
								}
							} else {
								if(!e.ctrlKey) { // Select one
									grid.jqGrid("resetSelection");
								}
								
								grid.init_list_row_id = row_id; // Remove start shift
							}
							return true;
						}
					});
				
					grid.processData(data_respond, ['facilityId']);
					grid.controlSize();
					grid.hideCol("cb"); // Hide check box
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu:function(event,menu){
								var row_id = $(event.target).closest("tr").attr("id")
								,selrows   = grid.getGridParam("selarrrow")
								;
								
								if(selrows.length){
									if($.inArray(row_id,selrows)==-1){
										grid.jqGrid("resetSelection");
									}else{
										grid.jqGrid("setSelection",row_id,false);
									}
								}
								
								grid.jqGrid("setSelection",row_id,true);
								grid.init_list_row_id = row_id;
								
								
								if(grid.getGridParam("selarrrow").length > 0){
									$mn.children("#restart").removeClass("ui-state-disabled");
									$mn.children("#moduleupdate").removeClass("ui-state-disabled");
									$mn.children("#restart").removeClass("ui-state-default");
									$mn.children("#moduleupdate").removeClass("ui-state-default");
									
								}else{
									$mn.children("#restart").addClass("ui-state-disabled");
									$mn.children("#moduleupdate").addClass("ui-state-disabled");
									$mn.children("#restart").addClass("ui-state-default");
									$mn.children("#moduleupdate").addClass("ui-state-default");
								}
															
								return true;
							}
							,container : grid.$ctn
							,bindings  :{
								restart : function(){
									_.agentRestart();
								}
								,moduleupdate : function(){
									_.agentUpdate();
								}
							}
							,menuStyle:{
								width: '160px'
							}
						}
					);
				}
				,error   : __.loadDataError
			});
		}
	 
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			,_grid = _.grid
			;

			// Bind ESC key to reset selection.
			_grid.keydown(function(event){
				// ESC key
				if(event.keyCode == 27){
					_grid.jqGrid("resetSelection");
					_.restartButtonDisable();
				}
			});
			
			_btns.children("#restart").click(function(){
				_.agentRestart();
			});
			
			_btns.children("#moduleupdate").click(function(){
				_.agentUpdate();
			});	

			
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData(null, true);
			});
		}
		,/*
		* 再起動・モジュールアップデートボタンの有効無効を変更
		*/
		restartButtonDisable: function(){
			var _   = this
			,grid   = _.grid
			,isSelected = (grid.getGridParam("selarrrow").length < 1);// 行を選択しているか？
			
			// ボタン押下禁止
			_.$btns.children("#restart").attr("disabled",isSelected);
			_.$btns.children("#moduleupdate").attr("disabled",isSelected);
			
			// 無効の場合はグレーアウト
			if(isSelected){
				_.$btns.children("#restart").addClass("ui-state-disabled");
				_.$btns.children("#moduleupdate").addClass("ui-state-disabled");
				_.$btns.children("#restart").addClass("ui-state-default");
				_.$btns.children("#moduleupdate").addClass("ui-state-default");
			}else{
				_.$btns.children("#restart").removeClass("ui-state-disabled");
				_.$btns.children("#moduleupdate").removeClass("ui-state-disabled");
				_.$btns.children("#restart").removeClass("ui-state-default");
				_.$btns.children("#moduleupdate").removeClass("ui-state-default");
			}
		}
		,/*
		* 再起動・モジュールアップデートリクエスト送信
		*/
		agentRestartAjax: function(post_data){
			var _ = this;
			$.ajax({
				url      : "agent_restart"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,data: post_data
				,success : function(data_respond){
					__.checkJsonError(data_respond,true);
				}
				,error   : __.loadDataError
			})
		}
		,/*
		*　選択した行の文字列を取得して、確認ダイアログを表示させる
		*/
		agentAction: function(isUpdate){
			var _   = this
			,grid   = _.grid
			,row_id
			,col_name = "facilityId"
			,list     = []
			,displist  = []
			,selrows  = grid.getGridParam("selarrrow")
			,cnt_row  = selrows.length
			;
			
			// 列が選択されていない場合は何もしない
			if(cnt_row==0){
				return;
			}
			
			// 選択行の一覧をリストに配置
			while(cnt_row--){
				list[list.length] = grid.getRowData(selrows[cnt_row]).facilityId;
				displist[displist.length] = $.jgrid.htmlEncode(grid.getRowData(selrows[cnt_row]).facilityName) + "("
											+ grid.getRowData(selrows[cnt_row]).facilityId + ")";
			}
			
			// 確認ダイアログの表示
			_.openConfirmDlg(list,displist,isUpdate);
		}
		,/*
		* 再起動ボタンを押したとき
		*/
		agentRestart: function(){
			var _   = this;
			_.agentAction(false);
		}
		,/*
		* モジュールアップデートボタンを押したとき
		**/
		agentUpdate: function(){
			var _   = this;
			_.agentAction(true);
		}
		,/*
		* 確認ダイアログを表示
		* list - 選択行一覧（ファシリティIDのみ）、サーバ送信用
		* displist - 選択行一覧（ファシリティID、ファシリティ名）、ダイアログ表示用
		* isUpdate - true：モジュールアップデート、false：再起動
		*/ 
		openConfirmDlg: function(list,displist,isUpdate){
			var _   = this
			,content1_str
			,content2_str
			,title_str = "confirmed"
			,action_str;
			
			// 確認ダイアログ用の文字列キー
			if(isUpdate){
				content1_str = "agent_update_confirmed_1";
				content2_str = "agent_update_confirmed_2";
				action_str   = "update"
			}else{
				content1_str = "agent_restart_confirmed_1";
				content2_str = "agent_restart_confirmed_2";
				action_str   = "restart"
			}
			
			// 確認ダイアログ表示
			__.openConfirmDlg(
				{
					content : __.getLang(content1_str)+displist.join()+__.getLang(content2_str)
					,title : __.getLang(title_str)
				},
				// OKボタン押下時の処理、サーバにリクエストを送信
				function(){
					_.agentRestartAjax({
						facilityId:list,
						action:action_str
					});
				}
			);
		}

		
	});
	
	return view;
};