/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Create (job management) NODE_DETAIL
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid, {
		session_id : ""
		,job_id    : ""
		,jobunit_id: ""
		,facility_id: ""
			
		,/*
		 * Set caption of grid
		 */
		setCaption: function(){
			var _ = this;
			
			_.grid.setCaption([
				__.getLang("session_id"), ": ", _.session_id
				,",&nbsp;"
				,__.getLang("job_id"), ": " , _.job_id
			].join(""));
		}
		
		,/*
		 * Update data when click on view 'history' content
		 */
		updateData: function(){
			var _       = this 
			,session_id = _view.__session_id
			,job_id     = _view.__job_id
			,jobunit_id = _view.__jobunit_id
			,grid       = _.grid
			;
			
			// Check for update data
			if((session_id !== _.session_id) 
				|| (job_id !== _.job_id)
				|| (jobunit_id !== _.jobunit_id)){
				_.facility_id = "";
			}
			
			// Get new value of session_id and job_id
			_.session_id = session_id;
			_.job_id     = job_id;
			_.jobunit_id = jobunit_id;
			_.setCaption();
			
			// Check to clear?
			if((session_id == "")
				|| (job_id == "")
				|| (jobunit_id == "")
				){
				grid.clearGridData();
				
				// Disable button "start" and "stop"
				_.$btns.children("#start").attr("disabled", true);
				_.$btns.children("#start").addClass("ui-state-default");
				_.$btns.children("#stop").attr("disabled", true);
				_.$btns.children("#stop").addClass("ui-state-default");
				return;
			}
			
			$("#load_grid_jobmanagement_node_detail").show();
			// Reload grid
			grid.refreshData({sessionId: session_id, jobId: job_id, jobunitId: jobunit_id});
		}
		
		,/*
		 * Get grid data
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_node_detail_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					var grid   = _.grid
					,post_data = {}
					,$mn       = grid.siblings("#menu_rightclick").children("ul:first")
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Check session_id of view: control
					if(_view.__session_id){
						_.session_id = _view.__session_id;
						
						post_data.sessionId = _.session_id;
					}
					
					if(_view.__job_id){
						_.job_id = _view.__job_id;
						
						post_data.jobId = _.job_id;
					}
					
					if(_view.__jobunit_id){
						_.jobunit_id = _view.__jobunit_id;
						
						post_data.jobunitId = _.jobunit_id;
					}
					
					// Set some options for grid
					$.extend(data_respond, {
						caption         : "&nbsp;"
						,url            : "get_node_detail"
						,postData       : post_data
						,ajaxGridOptions: {
							// This function prevent grid send request without 
							//   sessionId or sessionId = "", jobId = "", jobunitId = ""
							beforeSend: function (jqXhr, settings){
								var str_params = settings.data // form: a=b&c=d ...
								,params    = str_params.split("&")
								,cnt_param = params.length
								,sum_check = 3 // Check 2 parameter
								,cnt_check = 0 // Initialize value of counter of check
								;
								
								// Check every parameter (form: a=b)
								
								while(cnt_param--){
									var str_param = params[cnt_param]
									,param = str_param.split("=")
									;
									
									// Check parameter:
									if(param[0] && param[1]){
										if((param[0] == "sessionId")
											|| (param[0] == "jobId")
											|| (param[0] == "jobunitId")){
											cnt_check++;
										}
									}
									
									// Sum of parameter is ok
									if(cnt_check == sum_check){
										return true;
									}
								}
								
								return false;
							}
						}
						,gridComplete   : function(){
							var $gr = $(this);
							$gr.find("button.btn-in-cell").each(function(){
								$(this).click(function(e){
									var $i = $(this)
									,$div = $i.siblings("div:first")
									;
									if($div.length != 0){
										var message = $div.children("span:first").html();
										if(message && (message != "&nbsp;")){
											__.openTextDlg({
												content: __.replaceUrlWithHtmlLinks(message, true)
												,title : __.getLang("message")
											});
										}
									}
									
									e.stopPropagation();
								});
							});
							
							$gr.find("div.container-message").each(function(){
								$(this).click(function(e){
									var $i = $(this)
									,$btn = $i.siblings("button:first");
									;
									
									$btn.css("display", "inline-block")
										.addClass("btn-display-marker");
								});
							});
						}
						,loadComplete   : function(){
							var curent_facility_id= _.facility_id;

							if (curent_facility_id !== undefined && curent_facility_id.length > 0) {
                            
								var in_node_detail = $(grid).find('tr').filter(function(){
									return ($(this).find('td:nth-child(3)').first().text() == curent_facility_id);
								});
								
								if (in_node_detail.length > 0){
									var row_id = $(in_node_detail[0]).attr('id');
									grid.jqGrid('setSelection',row_id);
								}
							}

							// Disable button "start" and "stop"
							if(!grid.getGridParam("selrow")) {
								_.$btns.children("#start").attr("disabled", true);
								_.$btns.children("#start").addClass("ui-state-default");
								_.$btns.children("#stop").attr("disabled", true);
								_.$btns.children("#stop").addClass("ui-state-default");
							}
						}
						,onSelectRow    : function(row_id){
							var i     = this
							,row_data = $(i).getRowData(row_id)
							,facility_id     = $.jgrid.htmlEncode(row_data.facilityId)
							;
							
							_.facility_id = facility_id;
							
							// Enable button "start" and "stop"
							_.$btns.children("#start").attr("disabled", false);
							_.$btns.children("#start").removeClass("ui-state-default");
							_.$btns.children("#stop").attr("disabled", false);
							_.$btns.children("#stop").removeClass("ui-state-default");
						}
					});
					
					grid.processData(data_respond);
					grid.controlSize();
					_.setCaption();
					
					// Bind context menu for grid(right click)
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu: function(event, menu){
								var row_id = $(event.target).closest("tr").attr("id")
								,selrow    = grid.getGridParam("selrow")
								;
								
								if (!selrow || (selrow != row_id)) {
									// After this action happen, it will call onSelectRow
									grid.jqGrid("setSelection", row_id, true);
									grid.init_list_row_id = row_id;
								}
								
								if(!grid.getGridParam("selrow")) {
									// Disable menu "start" and "stop"
									$mn.children("#start").attr("disabled", true);
									$mn.children("#start").addClass("ui-state-disabled");
									$mn.children("#start").addClass("ui-state-default");
									$mn.children("#stop").attr("disabled", true);
									$mn.children("#stop").addClass("ui-state-disabled");
									$mn.children("#stop").addClass("ui-state-default");
								} else {
									// Enable menu "start" and "stop"
									$mn.children("#start").attr("disabled", false);
									$mn.children("#start").removeClass("ui-state-disabled");
									$mn.children("#start").removeClass("ui-state-default");
									$mn.children("#stop").attr("disabled", false);
									$mn.children("#stop").removeClass("ui-state-disabled");
									$mn.children("#stop").removeClass("ui-state-default");
								}
								return true;
							}
							,container   : grid.$ctn
							,bindings    : {
								start    : function(){
									_.startJob();
								}
								,stop    : function(){
									_.stopJob();
								}
							}
						}
					);
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare operation job dialog
			__.createOperationDialog.call(
				_
				,"operationjob"
				,{
					option: {
						title   : ""
						,width  : 450
						,height : 300
						,open   : function(){
							$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(0)").focus();
						}
						,buttons: [
							{
								text  : __.getLang("ok_o")
								,click: function(){
									var retData = _.operationjob.checkInputs();
									
									switch (retData.result) {
										case 0:
											_.operationjob.execute();
											$(this).dialog("close");
											break;
										case 1:
											$(this).dialog("close");
											__.openPromptDlg({
												message: {content:retData.message
														  ,title :retData.title}
												,level : retData.level
												,title : retData.title
											}, false);
											break;
										case 2:
											__.openPromptDlg({
												message: {content:retData.message
														  ,title :retData.title}
												,level : retData.level
												,title : retData.title
											}, false);
											break;
										default:
											_.operationjob.execute();
											$(this).dialog("close");
											break;
									}
								}
							}
							,{
								text  : __.getLang("cancel")
								,click: function(){
									$(this).dialog("close");
								}
							}
						]
					}
					,url  : "get_operation_job_property"
				}
			);
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			;
			
			// Bind start button
			_btns.children("#start").click(function(){
				_.startJob();
			});
			
			// Bind stop button
			_btns.children("#stop").click(function(){
				_.stopJob();
			});
		}
		
		,/*
		 * Start job
		 */
		startJob: function(){
			var _   = this
			,grid   = _.grid
			,row_id = grid.getGridParam("selrow")
			;
			if(row_id == null || row_id <= 0){
				row_id = grid.onclick_row_id;
			}	
			if(row_id){
				var operationjob = _.operationjob
				,row_data  = grid.getRowData(row_id)
				;
				
				// Set post data
				operationjob.setPostData({
					control     : "start"
					,sessionId  : _view.__session_id
					,jobunitId  : _view.__jobunit_id
					,jobId      : _view.__job_id
					,facilityId : $.jgrid.htmlEncode(row_data.facilityId)
				});
				
				// Set dialog title
				operationjob.setTitleText(__.getLang("job") + "[" + __.getLang("start") + "]");
				
				// Open dialog
				operationjob.open();
			}
		}
		
		,/*
		 * Stop job
		 */
		stopJob: function(){
			var _   = this
			,grid   = _.grid
			,row_id = grid.getGridParam("selrow")
			;
			if(row_id == null || row_id <= 0){
				row_id = grid.onclick_row_id;
			}	
			if(row_id){
				var operationjob = _.operationjob
				,row_data  = grid.getRowData(row_id)
				;
				
				// Set post data
				operationjob.setPostData({
					control     : "stop"
					,sessionId  : _view.__session_id
					,jobunitId  : _view.__jobunit_id
					,jobId      : _view.__job_id
					,facilityId : $.jgrid.htmlEncode(row_data.facilityId)
				});
				
				// Set dialog title
				operationjob.setTitleText(__.getLang("job") + "[" + __.getLang("stop") + "]");
				
				// Open dialog
				operationjob.open();
			}
		}
	});
	
	return view;
};