/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create (job management) HISTORY
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid, {
		/*
		 * Update data for jobDetail
		 */
		updateJobDetail: function(session_id){
			var _ = this
			,vw_dtl
			;
			
			// Check whether view "job detail" exists
			if(!(vw_dtl = _pers["job_detail"])){
				return;
			}
			// Update data for view detail
			vw_dtl.updateData({session_id: session_id});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_history_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,pager   = grid.$pgr
					,$mn       = grid.siblings("#menu_rightclick").children("ul:first")
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url          : "get_history"
						,caption     : "&nbsp;"
						,pager       : pager
						,viewrecords : true
						,loadComplete: function(){
							// Set refresh data
							_view.setRefresh();
							
							// Reload Job[JobDetail] after Job[History] be loaded
							var curent_session_id  = _pers["job_detail"].__session_id;

							if (curent_session_id !== undefined && curent_session_id.length > 0) {
								var in_history = grid.find("td:nth-child(4)").filter(function() {
									return $(this).text() == curent_session_id;
								});
								
								var curent_jobunit_id = _pers["node_detail"].__jobunit_id;
								var curent_job_id     = _pers["node_detail"].__job_id;
								_.updateJobDetail('');
								if (in_history.length > 0) {
									if (curent_jobunit_id !== undefined && curent_jobunit_id.length > 0
										&& curent_job_id !== undefined && curent_job_id.length > 0) {
										_pers["node_detail"].__session_id = curent_session_id;
										_pers["node_detail"].__jobunit_id = curent_jobunit_id;
										_pers["node_detail"].__job_id = curent_job_id;
									}
									
									var row_id = $(in_history[0]).parent().attr('id');
									grid.jqGrid('setSelection',row_id);
									_.updateJobDetail(curent_session_id);
								}
							}
							
							if(!grid.getGridParam("selrow")) {
								// Disable button "start" and "stop"
								_.$btns.children("#start").attr("disabled", true);
								_.$btns.children("#start").addClass("ui-state-default");
								_.$btns.children("#stop").attr("disabled", true);
								_.$btns.children("#stop").addClass("ui-state-default");
							}
						}
						,onSelectRow : function(row_id){
							var i     = this
							,row_data = $(i).getRowData(row_id)
							;
							
							// Enable button "start" and "stop"
							_.$btns.children("#start").attr("disabled", false);
							_.$btns.children("#start").removeClass("ui-state-default");
							_.$btns.children("#stop").attr("disabled", false);
							_.$btns.children("#stop").removeClass("ui-state-default");
							
							_.updateJobDetail($.jgrid.htmlEncode(row_data.sessionId));
						}
					});
				
					grid.processData(data_respond);
					grid.controlSize();
					
					// Bind context menu for grid(right click)
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu: function(event, menu){
								var row_id = $(event.target).closest("tr").attr("id")
								,selrow    = grid.getGridParam("selrow")
								;
								
								if (!selrow || (selrow != row_id)) {
									// After this action happen, it will call onSelectRow
									grid.jqGrid("setSelection", row_id, true);
									grid.init_list_row_id = row_id;
								}
								
								if(!grid.getGridParam("selrow")) {
									// Disable menu "start" and "stop"
									$mn.children("#start").attr("disabled", true);
									$mn.children("#start").addClass("ui-state-disabled");
									$mn.children("#start").addClass("ui-state-default");
									$mn.children("#stop").attr("disabled", true);
									$mn.children("#stop").addClass("ui-state-disabled");
									$mn.children("#stop").addClass("ui-state-default");
								} else {
									// Enable menu "start" and "stop"
									$mn.children("#start").attr("disabled", false);
									$mn.children("#start").removeClass("ui-state-disabled");
									$mn.children("#start").removeClass("ui-state-default");
									$mn.children("#stop").attr("disabled", false);
									$mn.children("#stop").removeClass("ui-state-disabled");
									$mn.children("#stop").removeClass("ui-state-default");
								}
								return true;
							}
							,container   : grid.$ctn
							,bindings    : {
								start    : function(){
									_.startJob();
								}
								,stop    : function(){
									_.stopJob();
								}
							}
						}
					);
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare filter dialog
			__.crePropActnDlg.call(
				_
				,"filter"
				,{
					option: {
						title   : _pers.getTitle("filter_histories")
						,width  : 400
						,height : 330
						,open   : function(){
							$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(1)").focus();
						}
						,buttons: [
							{
								text  : __.getLang("clear")
								,click: function(){
									_.filter.reset("filter");
								}
							}
							,{
								text  : __.getLang("ok_o")
								,click: function(){
									_.filter.execute(function(post_data){
										var _ = this;
										
										// Extend filter is true
										$.extend(post_data, {filter: true});
										
										// Refresh data
										_.grid.refreshData(post_data)
										
										// Store filter active
										_.filter_active = true;
										
										// Set caption
										_.grid.setCaption(__.getLang("filtered_list"));
										
										// Add class button active
										_.$btns.children("#filter").addClass("ui-button-active");
									});
									
									$(this).dialog("close");
								}
							}
							,{
								text  : __.getLang("cancel")
								,click: function(){
									_.filter.storeValues();
									$(this).dialog("close");
								}
							}
						]
					}
					,url  : "get_history_filter_property"
				}
				,function(){
					var $input = _.filter.$dlg.$bd
						.find(":input.input-jobid:first")
					,$btn = $input.siblings("button:first");
					;
					
					if($btn.length != 0){
						$btn.text("...")
							.css("visibility", "hidden")
							.click(function(){
								// Open text dialog
								_pers.openTreeJobDlg($input);
							});
						
						$input.click(function(){
							$btn.css("visibility", "visible");
						});
					}
				}
			);
			
			// Declare operation job dialog
			__.createOperationDialog.call(
				_
				,"operationjob"
				,{
					option: {
						title   : ""
						,width  : 450
						,height : 300
						,open   : function(){
							$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(0)").focus();
						}
						,buttons: [
							{
								text  : __.getLang("ok_o")
								,click: function(){
									var retData = _.operationjob.checkInputs();
									
									switch (retData.result) {
										case 0:
											_.operationjob.execute();
											$(this).dialog("close");
											break;
										case 1:
											$(this).dialog("close");
											__.openPromptDlg({
												message: {content:retData.message
														  ,title :retData.title}
												,level : retData.level
											}, false);
											break;
										case 2:
											__.openPromptDlg({
												message: {content:retData.message
														  ,title :retData.title}
												,level : retData.level
												,title : retData.title
											}, false);
											break;
										default:
											_.operationjob.execute();
											$(this).dialog("close");
											break;
									}
								}
							}
							,{
								text  : __.getLang("cancel")
								,click: function(){
									$(this).dialog("close");
								}
							}
						]
					}
					,url  : "get_operation_job_property"
				}
			);
		}
		
		,/*
		 * Refresh data
		 */
		refreshData: function(){
			this.grid.refreshData();
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			,_grid = _.grid
			;
			
			// Bind actions for button in left of pane
			// Bind filter
			_btns.children("#filter").click(function(){
				if(_.filter_active){
					// Inactive filter for filter grid
					_grid.refreshData({filter: false});
					_grid.setCaption("&nbsp;");
					
					// Process CSS for button
					$(this).removeClass("ui-button-active");
					_.filter_active = false;
				}else{
					// Open dialog which contain filter property grid
					_.filter.open();
				}
			});
			
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
			
			// Bind start button
			_btns.children("#start").click(function(){
				_.startJob();
			});
			
			// Bind stop button
			_btns.children("#stop").click(function(){
				_.stopJob();
			});
		}
		
		,/*
		 * Start job
		 */
		startJob: function(){
			var _   = this
			,grid   = _.grid
			,row_id = grid.getGridParam("selrow")
			;
			if(row_id == null || row_id <= 0){
				row_id = grid.onclick_row_id;
			}	
			if(row_id){
				var operationjob = _.operationjob
				,row_data  = grid.getRowData(row_id)
				;
				
				// Set post data
				operationjob.setPostData({
					control     : "start"
					,sessionId  : $.jgrid.htmlEncode(row_data.sessionId)
					,jobunitId  : $.jgrid.htmlEncode(row_data.jobuinitId)
					,jobId      : $.jgrid.htmlEncode(row_data.jobId)
				});
				
				// Set dialog title
				operationjob.setTitleText(__.getLang("job") + "[" + __.getLang("start") + "]");
				
				// Open dialog
				operationjob.open();
			}
		}
		
		,/*
		 * Stop job
		 */
		stopJob: function(){
			var _   = this
			,grid   = _.grid
			,row_id = grid.getGridParam("selrow")
			;
			if(row_id == null || row_id <= 0){
				row_id = grid.onclick_row_id;
			}	
			if(row_id){
				var operationjob = _.operationjob
				,row_data  = grid.getRowData(row_id)
				;
				
				// Set post data
				operationjob.setPostData({
					control     : "stop"
					,sessionId  : $.jgrid.htmlEncode(row_data.sessionId)
					,jobunitId  : $.jgrid.htmlEncode(row_data.jobuinitId)
					,jobId      : $.jgrid.htmlEncode(row_data.jobId)
				});
				
				// Set dialog title
				operationjob.setTitleText(__.getLang("job") + "[" + __.getLang("stop") + "]");
				
				// Open dialog
				operationjob.open();
			}
		}
	});
	
	return view;
};