/*
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare and initialize common variant, the ancestor
 */
var cm = {
	/************************************************************
	 * Convert function
	 */
	/*
	 * Get selector of perspective from its name
	 */
	per2Selr: function(per_nm){
		return ["#per_", per_nm].join("");
	}
	
	,/*
	 * Get name of perspective from its id: the reversion of per2Selr
	 */
	selr2Per: function(selr){
		return selr.slice(5);
	}
	
	,/*
	 * Get selector of panel from its name
	 */
	layout2Selr: function(per_nm, lay_no){
		return ["#", per_nm, "_layout_", lay_no].join("");
	}
	
	,/*
	 * Get selector of panel from its name
	 */
	panel2Selr: function(per_nm, pan_no, lay_no){
		return ["#", per_nm, "_panel_", lay_no, "_", pan_no].join("");
	}
	
	,/*
	 * Get URL layout from its name
	 */
	getCompLayUrl: function(dir_nm, comp_nm){
		// Set url start with servlet path of layout
		return ["layout", dir_nm, comp_nm.toCamel()].join("/");
	}
	
	,/*
	 * Get URL JS from its name
	 */
	getUrlJs: function(dir_nm, comp_nm){
		// Add extension ".js"
		comp_nm = [comp_nm.toCamel(), ".js"].join("");
		
		// Set url start with servlet path of layout
		return ["js", dir_nm, comp_nm].join("/");
	}
	
	,/*
	 * Get function name of JS for constructing view or dialog
	 */
	getFnJs: function(name){
		return ["create_" + name].join("").toCamel();
	}
	
	,/*
	 * Get icon String
	 */
	getIconStr: function(cls) {
		return ["<span class='ui-icon ", cls, "'", "></span>"].join("");
	}
	
	,/*
	 * Get layout for dialog title
	 */
	getIconStrTitle: function(val){
		return [
			"<span class='ui-icon ui-icon-hnm-small'", "></span>"
			,"&nbsp;"
			,val
		].join("");
	}
	
	,/************************************************************
	 * Action window
	 */
	/*
	 * Redirect to login
	 */
	redirectLogin: function(){
		window.location.href = "login";
	}
	
	,/*
	 * Process when press button login on menu
	 */
	login: function(){
		var __ = cm;
		__.openConfirmDlg(
			{
				title   : __.getLang("confirmed")
				,content: __.getLang("confirm_login")
			}
			,__.redirectLogin
		);
	}
	
	,/*
	 * Log out action
	 */
	logout: function(){
		window.location.href = "logout";
	}
	
	,/*
	 * Check and process error
	 * *
	 * Parameters:
	 *   data: respond data json
	 *   show: whether show confirm dialog
	 */
	checkJsonError: function(data, show, logoutWhenError){
		var __ = this
		,level
		,message
		,ret
		;
		
		if ((logoutWhenError === undefined) || (logoutWhenError != false)){
			logoutWhenError = true;
		}
		
		// Check validation of data
		if((!data) || (data.result === null) || (data.result === undefined)){
			__.loadDataError();
			return false;
		}
		
		// Check whether result does not have problem
		if((level = data.result) === __.LEVEL_OK){
			return true;
		}
		
		// Check and set error level and message
		if(!(message = data.message)){
			message = "";
		}
		
		if((level == __.LEVEL_INFO) || (level == __.LEVEL_WARNING)){
			// Check whether show warning message
			if(show !== false){
				show = true;
			}
			ret = {message: message, level: level};
		}else{
			show = true;
			ret  = false;
		}
		
		// Show message
		if(show){
			__.openPromptDlg({
				message: message
				,level : level
			}, logoutWhenError);
		}
		
		return ret;
	}
	
	,/*
	 * Settle errors of getting data using Ajax
	 * *
	 * Parameter:
	 *   xhr   : XMLHttpRequest object
	 *   status: A string describing the type of error
	 */
	loadDataError: function(xhr, status){
		var __ = cm;
		
		__.openPromptDlg({
			message: __.getLang("error_connection")
			,level : __.LEVEL_ERROR
		});
	}
    
    ,/*
    * Replace URL With HTML Links in text
    */
    replaceUrlWithHtmlLinks: function(text, new_tab) {
        if (text) {
            var exp = /(&lt;|&gt;)/ig;
            var strReplace = " $1";
            text = text.replace(exp, strReplace);
            
            exp = /(\b(https?|ftp|file):\/\/[-A-Z0-9+&@#$()'*{}`\[\]\\"^\/%?=~_|!:,.;]*[-A-Z0-9+&@#$()'*{}`\[\]\\"^\/%?=~_|])/ig;
            if (new_tab) {
                strReplace = "<a href='$1' target='_blank' >$1</a>";
            } else {
                strReplace = "<a href='$1'>$1</a>";
            }
            text = text.replace(exp, strReplace);
            
            exp = /( &lt;)/ig;
            strReplace = "&lt;";
            text = text.replace(exp, strReplace);
            exp = /( &gt;)/ig;
            strReplace = "&gt;";
            text = text.replace(exp, strReplace);
        }
        return text;
    }
    ,/*
    * Get key of node in tree
    */
    getNodeKey : function getNodeKey(node, facility_id) {
        if (node.facilityId == facility_id){
            if (node.children.length > 0) {
                return node.key;
            } else {
                return;
            }
        } else {
            var key;
            $.each(node.children, function() {
                key = getNodeKey(this, facility_id);
                if (typeof key != 'undefined') {
                    return false;
                }
            });
            
            if (typeof key != 'undefined') {
                return key;
            }
        }
    }
};