/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

import org.apache.log4j.Logger;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.accesscontrol.ejb.session.AccessCheck;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheckHome;

/**
 * Hinemosマネージャへの接続を管理するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LoginManager implements Serializable {

    /**
	 * 
	 */
    private static final long serialVersionUID = -3748411922824085497L;

    private static Logger m_log = Logger.getLogger(LoginManager.class);

    private LoginContext m_loginContext = null;

    private NamingContext m_namingContext = null;

    private String m_userName = null;

    private String m_password = null;

    private String m_urlServer = null;

    private static Configuration config;

    private static boolean initialized = false;

    /**
     * Custom deserialization is needed.
     */
    private void readObject(ObjectInputStream aStream) throws IOException,
            ClassNotFoundException {
        aStream.defaultReadObject();
    }

    /**
     * Custom serialization is needed.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.defaultWriteObject();
    }

    public LoginManager() {
        if (!initialized) {
            initialized = true;
            config = new HinemosClientConfig();
        }
    }

    public void login(String userName, String password, String urlServer)
            throws NamingException, LoginException, RemoteException,
            CreateException {
        // 　ユーザ名・パスワードを設定
        this.m_userName = userName;
        this.m_password = password;

        // namingContext取得
        getContext(urlServer);

        // ログインチェック
        AccessCheckHome home = (AccessCheckHome) this.m_namingContext
                .lookup(AccessCheckHome.JNDI_NAME);
        AccessCheck accessCheck = home.create();
        accessCheck.checkLogin();
    }

    public void logout() {
        logoutEndRequest();

        this.m_loginContext = null;
        this.m_namingContext = null;
    }

    public void logoutEndRequest() {
        if (this.m_loginContext instanceof LoginContext) {
            try {
                this.m_loginContext.logout();
            } catch (LoginException e) {
                m_log.error(e.getMessage());
            }
        }
    }

    private void getContext(String urlServer) throws NamingException,
            LoginException {
        // 接続先URL取得
        this.m_urlServer = urlServer;
        Hashtable<String, String> props = new Hashtable<String, String>();

        props.put(InitialContext.PROVIDER_URL, this.m_urlServer);

        UsernamePasswordHandler handler = new UsernamePasswordHandler(
                this.m_userName, this.m_password.toCharArray());
        this.m_loginContext = new LoginContext("hinemosClient", new Subject(),
                handler, config);
        this.m_loginContext.login();

        NamingContextFactory ncf = new NamingContextFactory();
        this.m_namingContext = (NamingContext) ncf.getInitialContext(props);
    }

    public NamingContext getNamingContext() {
        return this.m_namingContext;
    }

    public boolean refresh() {
        boolean result = true;
        try {
            if (m_loginContext != null) {
                m_loginContext.login();
                /*
                 * if (m_loginContext == null) { result = false; } else { result
                 * = true; }
                 */
            } else {
                m_log.error("m_loginContext is null");
                result = false;
            }
        } catch (LoginException e) {
            m_log.error(e.getMessage());
            result = false;
        }

        return result;
    }

    /**
     * HinemosClient用のコンフィギュレーションクラス
     * 
     */
    class HinemosClientConfig extends Configuration {
        /*
         * (non-Javadoc)
         * 
         * @see javax.security.auth.login.Configuration#refresh()
         */
        @Override
        public void refresh() {

        }

        /*
         * (non-Javadoc)
         * 
         * @see
         * javax.security.auth.login.Configuration#getAppConfigurationEntry(
         * java.lang.String)
         */
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] entry = null;
            try {
                Class[] parameterTypes = {};
                Method m = getClass().getDeclaredMethod(name, parameterTypes);
                Object[] args = {};
                entry = (AppConfigurationEntry[]) m.invoke(this, args);
            } catch (Exception e) {
            }
            return entry;
        }

        /**
         * Hinemos Client Configuration
         * 
         * http://community.jboss.org/wiki/ClientLoginModule
         * 
         * @return
         */
        AppConfigurationEntry[] hinemosClient() {
            String name = "org.jboss.security.ClientLoginModule";
            HashMap options = new HashMap();
            options.put("multi-threaded", "true"); // login credential is global
                                                   // variables (all thread)
            options.put("restore-login-identity", "false");
            AppConfigurationEntry ace = new AppConfigurationEntry(name,
                    AppConfigurationEntry.LoginModuleControlFlag.REQUIRED,
                    options);
            AppConfigurationEntry[] entry = { ace };
            return entry;
        }
    }
}
