/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetScopeList;
import com.necsoft.hinemos.webclient.repository.form.ScopeListForm;

/**
 * This class used for get data of Scope view
 * 
 * @version 1.0
 * @date 2011/12/14
 */
public class GetScopeListBusiness {

    public GridDataJson getScopeList(ScopeListForm form,
            NamingContext namingContext) throws HinemosWebException {
        // スコープ情報一覧データ(ScopeInfoData)を取得

        GetScopeList scopeList = new GetScopeList();
        GridDataJson result = null;
        ArrayList<?> listInfoData = null;

        scopeList.setNamingContext(namingContext);
        listInfoData = scopeList.getScopeList(StringEscapeUtils
                .unescapeHtml(form.getFacilityId()));
        // sort data
        DataProcess.sortData(form, listInfoData,
                ScopeListTableDefine.SORT_COLUMN_INDEX_SECOND,
                ScopeListTableDefine.SORT_ORDER,
                RepositoryConstants.SCOPE_LIST_TABLE_HEADER_NUM);
        // convert to json
        result = DataProcess.doConvertToJson(DataProcess
                .stringEscape(listInfoData));

        return result;
    }
}
