/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.business;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.nodemap.bean.ReservedFacilityIdConstant;
import com.clustercontrol.repository.bean.FacilityInfo;
import com.necsoft.hinemos.webclient.action.FacilityTree;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.composite.FacilityTreeViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.repository.bean.FacilityTreeBean;
import com.necsoft.hinemos.webclient.repository.json.FacilityTreeJson;

/**
 * This class used to display Facility List Bussiness
 * 
 * @version 1.0
 * @date 2012/1/14
 */
public class GetFacilityListBusiness {

    /**
     * Get detail of Facility scope list
     * 
     * @param namingContext
     *            NamingContext
     * @return result JSON
     */
    public FacilityTreeJson getFacilityTree(NamingContext namingContext,
            Locale locale) throws HinemosWebException {
        FacilityTreeJson fclTreeJs = new FacilityTreeJson();
        Map<String, Integer> typeList = new HashMap<String, Integer>();

        // FacilityTree を取得
        FacilityTree facilityTree = new FacilityTree();
        facilityTree.setNamingContext(namingContext);
        // セパレータを取得
        FacilityPath path = new FacilityPath(facilityTree.getSeparator());

        // ファシリティ一覧を取得
        FacilityTreeItem treeItemRoot = facilityTree.getTreeItem(locale);

        if (treeItemRoot == null) {
            // エラー発生する場合、
            throw new HinemosWebInvalidDataException(
                    "exception.repository.facilitytree.data");
        }

        // Create data JSON
        FacilityTreeItem[] treeItems = treeItemRoot.getChildren();

        for (int cnt = 0; cnt < treeItems.length; cnt++) {
            fclTreeJs.addFacilityTree(treeItem2TreeBean(treeItems[cnt], path,
                    new StringBuffer(""), typeList));
        }

        fclTreeJs.setTypeList(typeList);
        fclTreeJs.setReservedList(getReservedList());

        return fclTreeJs;
    }

    /**
     * Convert FacilityTreeItem to FacilityTreeBean
     * 
     * @param treeItem
     * @param path
     * @param key
     * @return
     */
    private FacilityTreeBean treeItem2TreeBean(FacilityTreeItem treeItem,
            FacilityPath path, StringBuffer key, Map<String, Integer> typeList) {
        FacilityTreeBean treeBean = new FacilityTreeBean();
        FacilityInfo facilityInfo = treeItem.getData();
        StringBuffer title = new StringBuffer(facilityInfo.getFacilityName());
        String facilityId = facilityInfo.getFacilityId();
        int type = facilityInfo.getFacilityType();

        if (type != FacilityConstant.TYPE_COMPOSITE) {
            // Append title
            title.append(" (");
            title.append(facilityId);
            title.append(")");

            // Append key
            key.append(path.getSeparator());
            key.append(facilityId);

            typeList.put(StringEscapeUtils.escapeHtml(facilityId), type);
        }

        // Set component of FacilityTreeBean
        treeBean.setTitle(StringEscapeUtils.escapeHtml(title.toString()));
        treeBean.setTooltip(StringEscapeUtils.escapeHtml(title.toString()));
        treeBean.setFacilityId(StringEscapeUtils.escapeHtml(facilityId));
        treeBean.setPath(StringEscapeUtils.escapeHtml(path.getPath(treeItem)));
        treeBean.setKey(key.toString());

        // Set children of node
        if (type == FacilityConstant.TYPE_NODE) {
            // Not contain children, check valid of node
            if (!facilityInfo.isValid()) {
                treeBean.setAddClass(CssClass.TREE_NODE_INVALID);
                treeBean.setValid(false);
            }
        } else {
            // Set class for FacilityTreeBean
            treeBean.setIsFolder(true);
            if (type == FacilityConstant.TYPE_COMPOSITE) {
                treeBean.setAddClass(CssClass.TREE_SCOPE_ROOT);
            }

            // Set children for this FacilityTreeBean
            // データをソート
            List<FacilityTreeItem> treeItemChildren = Arrays.asList(treeItem
                    .getChildren());
            Collections.sort(treeItemChildren, new FacilityTreeViewerSorter());

            // 子ノードリストを取得
            for (int cnt = 0; cnt < treeItemChildren.size(); cnt++) {
                treeBean.addChildren(treeItem2TreeBean(
                        treeItemChildren.get(cnt), path, key, typeList));
            }
        }

        return treeBean;
    }

    private static Map<String, String> getReservedList() {
        Map<String, String> reservedList = new HashMap<String, String>();

        reservedList
                .put(StringEscapeUtils
                        .escapeHtml(ReservedFacilityIdConstant.INTERNAL_SCOPE),
                        StringEscapeUtils
                                .escapeHtml(ReservedFacilityIdConstant.INTERNAL_SCOPE_TEXT));

        reservedList
                .put(StringEscapeUtils
                        .escapeHtml(ReservedFacilityIdConstant.REGISTEREFD_SCOPE),
                        StringEscapeUtils
                                .escapeHtml(ReservedFacilityIdConstant.REGISTERED_SCOPE_TEXT));

        reservedList
                .put(StringEscapeUtils
                        .escapeHtml(ReservedFacilityIdConstant.UNREGISTEREFD_SCOPE),
                        StringEscapeUtils
                                .escapeHtml(ReservedFacilityIdConstant.UNREGISTEREFD_SCOPE));

        return reservedList;
    }
}
