/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.PropertyUtil;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.repository.util.EjbConnectionManager;
import com.necsoft.hinemos.webclient.repository.util.NodePropertyUtil;

public class GetNodeList {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * 全てのノード一覧を取得します。
     * 
     * @return ノード一覧
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList> getAll() throws HinemosWebException {
        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        RepositoryController repository = ejbConnectionManager
                .getRepositoryController();

        ArrayList<NodeInfo> records = null;
        try {
            records = repository.getNodeList();
        } catch (AccessException e) {
            throw new HinemosWebAccessException(
                    "exception.repository.node.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.repository.node.remote", e);
        }
        if (records == null) {
            throw new HinemosWebException("message.force.disconnect");
        }
        ArrayList<ArrayList> list = ConvertListUtil
                .convertNodeInfoListToArrayList(records);
        return list;
    }

    /**
     * propertyの条件にヒットするノードの一覧を返します。
     * 
     * @param property
     * @return ノード一覧
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList> get(Property property)
            throws HinemosWebException {
        PropertyUtil.deletePropertyDefine(property);

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        RepositoryController repository = ejbConnectionManager
                .getRepositoryController();

        ArrayList<NodeInfo> records = null;
        try {
            NodeInfo nodeInfo = null;
            nodeInfo = NodePropertyUtil.property2node(property);
            records = repository.getFilterNodeList(nodeInfo);
        } catch (AccessException e) {
            throw new HinemosWebAccessException(
                    "exception.repository.node.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.repository.node.remote", e);
        }
        if (records == null) {
            throw new HinemosWebException("message.force.disconnect");
        }
        ArrayList<ArrayList> list = ConvertListUtil
                .convertNodeInfoListToArrayList(records);
        return list;
    }
}
